/* ------------------------------------------------------------------------------
*
*  # Change language without page reload
*
*  Specific JS code additions for internationalization_switch_direct.html page
*
*  Version: 1.0
*  Latest update: Aug 1, 2015
*
* ---------------------------------------------------------------------------- */

$(function() {

    
    // Configuration
    // -------------------------

    // Hide sidebar category titles on load
    $('.category-title > span').css('visibility', 'hidden');

    // Add options
    i18n.init({
        resGetPath: 'assets/locales/__lng__.json',
        debug: true,
        fallbackLng: false,
        load: 'unspecific'
    },
    function () {
        
        // Init
        $('body').i18n();

        // Show sidebar category titles after load
        $('.category-title > span').css('visibility', 'visible');
    });



    // Change languages in dropdown
    // -------------------------

    // English
    if(i18n.lng() === "en") {

        // Set active class
        $('.english').parent().addClass('active');

        // Change language in dropdown
        $('.language-switch').children('.dropdown-toggle').html(
            $('.language-switch').find('.english').html() + ' <i class="caret" />'
        ).children('img').addClass('position-left');
    }


    // Arabic
    if(i18n.lng() === "ar") {

        // Set active class
        $('.arabic').parent().addClass('active');

        // Change language in dropdown
        $('.language-switch').children('.dropdown-toggle').html(
            $('.language-switch').find('.arabic').html() + ' <i class="caret" />'
        ).children('img').addClass('position-left');

        
    }


    // Kurdish
    if(i18n.lng() === "kr") {

        // Set active class
        $('.kurdish').parent().addClass('active');

        // Change language in dropdown
        $('.language-switch').children('.dropdown-toggle').html(
            $('.language-switch').find('.kurdish').html() + ' <i class="caret" />'
        ).children('img').addClass('position-left');
    }



    // Change languages in navbar
    // -------------------------

    // Define switcher container
    var switchContainer = $('.language-switch');


    // English
    $('.english').on('click', function () {

        let lang = 'ltr';
        setCookie('language-mode', lang, 365);

        setPageDir(lang,''); // set page direction


        // Set language
        $.i18n.setLng('en', function() {
            $('body').i18n();
        });

        // Change lang in dropdown
        switchContainer.children('.dropdown-toggle').html(
            $('.english').html() + ' <i class="caret" />'
        ).children('img').addClass('position-left');

        // Set active class
        switchContainer.find('li').removeClass('active');
        $('.english').parent().addClass('active');
    });


    // Russian
    $('.arabic').on('click', function () {

        let lang = 'rtl';
        setCookie('language-mode', lang, 365);

        setPageDir(lang,''); // set page direction

        // Set language
        $.i18n.setLng('ar', function() {
            $('body').i18n();
        });

        // Change lang in dropdown
        switchContainer.children('.dropdown-toggle').html(
            $('.arabic').html() + ' <i class="caret" />'
        ).children('img').addClass('position-left');
        
        // Set active class
        switchContainer.find('li').removeClass('active');
        $('.arabic').parent().addClass('active');
    });


    // Ukrainian
    $('.kurdish').on('click', function () {

        let lang = 'rtl';
        setCookie('language-mode', lang, 365);

        setPageDir(lang,''); // set page direction
        

        // Set language
        $.i18n.setLng('kr', function() {
            $('body').i18n();
        });

        // Change lang in dropdown
        switchContainer.children('.dropdown-toggle').html(
            $('.kurdish').html() + ' <i class="caret" />'
        ).children('img').addClass('position-left');
        
        // Set active class
        switchContainer.find('li').removeClass('active');
        $('.kurdish').parent().addClass('active');
    });

});
