
var table ;
var FREQUENCY_LIST, FORM_LIST, ROUTE_LIST;
var $price_profile = '';

function edit_items(itemid){
  
    $price_profile = '';

    $("#edit_form")[0].reset();

    $("#edited_id").val(itemid);
 

    $.ajax({
      url: "models/crul_breast_clinic.php",
      type:"POST",
      dataType : "JSON",
      data:{   "type":"get_edit",
                "edited_id":itemid,
                
            } ,
      complete:function(){
        
      },
      beforeSend:function(){
        
      },
      success: function(res) {


        if(res.is_success == true){

            $("#edit_breast_clinic_date").val(res.data[0].breast_clinic_date);
            $("#edit_main_complaint").val(res.data[0].main_complaint);
            $("#edit_duration").val(res.data[0].duration);
            $("#edit_laterality").val(res.data[0].laterality);
            $("#edit_progression").val(res.data[0].progression);
            $("#edit_lump_size").val(res.data[0].lump_size);
            $("#edit_lump_location").val(res.data[0].lump_location);
            $("#edit_lump_mobility").val(res.data[0].lump_mobility);
            $("#edit_discharge_color").val(res.data[0].discharge_color);
            $("#edit_discharge_consistency").val(res.data[0].discharge_consistency);
            $("#edit_discharge_side").val(res.data[0].discharge_side);
            $("#edit_pain_character").val(res.data[0].pain_character);
            $("#edit_pain_timing").val(res.data[0].pain_timing);
            $("#edit_other_conditions").val(res.data[0].other_conditions);
            $("#edit_current_medications").val(res.data[0].current_medications);
            $("#edit_hormonal_therapy").val(res.data[0].hormonal_therapy);
            $("#edit_drug_allergies").val(res.data[0].drug_allergies);
            $("#edit_other_allergies").val(res.data[0].other_allergies);
            $("#edit_breast_cancer_relation").val(res.data[0].breast_cancer_relation);
            $("#edit_breast_cancer_age").val(res.data[0].breast_cancer_age);
            $("#edit_ovarian_cancer_relation").val(res.data[0].ovarian_cancer_relation);
            $("#edit_ovarian_cancer_age").val(res.data[0].ovarian_cancer_age);
            $("#edit_genetic_syndromes").val(res.data[0].genetic_syndromes);
            $("#edit_menarche_age").val(res.data[0].menarche_age);
            $("#edit_last_period").val(res.data[0].last_period);
            $("#edit_pregnancies").val(res.data[0].pregnancies);
            $("#edit_live_births").val(res.data[0].live_births);
            $("#edit_breastfeeding_history").val(res.data[0].breastfeeding_history);
            $("#edit_hormonal_contraception").val(res.data[0].hormonal_contraception);
            $("#edit_menopause_age").val(res.data[0].menopause_age);
            $("#edit_occupation_exposure").val(res.data[0].occupation_exposure);
            $("#edit_physical_activity").val(res.data[0].physical_activity);
            $("#edit_other_symptoms").val(res.data[0].other_symptoms);
            $("#edit_mammogram_date").val(res.data[0].mammogram_date);
            $("#edit_mammogram_result").val(res.data[0].mammogram_result);
            $("#edit_ultra_sound_date").val(res.data[0].ultra_sound_date);
            $("#edit_ultra_sound_result").val(res.data[0].ultra_sound_result);
            $("#edit_biopsy_date").val(res.data[0].biopsy_date);
            $("#edit_biopsy_result").val(res.data[0].biopsy_result);
            $("#edit_lump_location_rv").val(res.data[0].lump_location_rv);
            $("#edit_lump_size_rv").val(res.data[0].lump_size_rv);
            $("#edit_lump_mobility_rv").val(res.data[0].lump_mobility_rv);
            $("#edit_axillary_nodes").val(res.data[0].axillary_nodes);
            $("#edit_patient_concerns_note").val(res.data[0].patient_concerns_note);

            res.data[0].smoking=='1' ? $("#edit_smoking\\[\\]").eq(0).prop('checked',true) : res.data[0].smoking=='2' ? $("#edit_smoking\\[\\]").eq(1).prop('checked',true) : $("#edit_smoking\\[\\]").prop('checked',false);
            res.data[0].alcohol=='1' ? $("#edit_alcohol\\[\\]").eq(0).prop('checked',true) : res.data[0].alcohol=='2' ? $("#edit_alcohol\\[\\]").eq(1).prop('checked',true) : $("#edit_alcohol\\[\\]").prop('checked',false);
            res.data[0].pain=='1' ? $("#edit_pain").prop('checked',true) : $("#edit_pain").prop('checked',false);
            res.data[0].nipple_discharge=='1' ? $("#edit_nipple_discharge").prop('checked',true) : $("#edit_nipple_discharge").prop('checked',false);
            res.data[0].skin_changes=='1' ? $("#edit_skin_changes").prop('checked',true) : $("#edit_skin_changes").prop('checked',false);
            res.data[0].systemic_symptoms=='1' ? $("#edit_systemic_symptoms").prop('checked',true) : $("#edit_systemic_symptoms").prop('checked',false);
            res.data[0].systemic_weight_loss=='1' ? $("#edit_systemic_weight_loss").prop('checked',true) : $("#edit_systemic_weight_loss").prop('checked',false);
            res.data[0].systemic_fever=='1' ? $("#edit_systemic_fever").prop('checked',true) : $("#edit_systemic_fever").prop('checked',false);
            res.data[0].systemic_fatigue=='1' ? $("#edit_systemic_fatigue").prop('checked',true) : $("#edit_systemic_fatigue").prop('checked',false);
            res.data[0].lump_tenderness=='1' ? $("#edit_lump_tenderness").prop('checked',true) : $("#edit_lump_tenderness").prop('checked',false);
            res.data[0].skin_redness=='1' ? $("#edit_skin_redness").prop('checked',true) : $("#edit_skin_redness").prop('checked',false);
            res.data[0].skin_dimpling=='1' ? $("#edit_skin_dimpling").prop('checked',true) : $("#edit_skin_dimpling").prop('checked',false);
            res.data[0].skin_ulceration=='1' ? $("#edit_skin_ulceration").prop('checked',true) : $("#edit_skin_ulceration").prop('checked',false);
            res.data[0].infections=='1' ? $("#edit_infections").prop('checked',true) : $("#edit_infections").prop('checked',false);
            res.data[0].trauma=='1' ? $("#edit_trauma").prop('checked',true) : $("#edit_trauma").prop('checked',false);
            res.data[0].previous_surgeries=='1' ? $("#edit_previous_surgeries").prop('checked',true) : $("#edit_previous_surgeries").prop('checked',false);
            res.data[0].benign_lumps=='1' ? $("#edit_benign_lumps").prop('checked',true) : $("#edit_benign_lumps").prop('checked',false);
            res.data[0].mastitis=='1' ? $("#edit_mastitis").prop('checked',true) : $("#edit_mastitis").prop('checked',false);
            res.data[0].biopsies_surgery=='1' ? $("#edit_biopsies_surgery").prop('checked',true) : $("#edit_biopsies_surgery").prop('checked',false);
            res.data[0].diabetes=='1' ? $("#edit_diabetes").prop('checked',true) : $("#edit_diabetes").prop('checked',false);
            res.data[0].hypertension=='1' ? $("#edit_hypertension").prop('checked',true) : $("#edit_hypertension").prop('checked',false);
            res.data[0].thyroid=='1' ? $("#edit_thyroid").prop('checked',true) : $("#edit_thyroid").prop('checked',false);
            res.data[0].cycle_regular=='1' ? $("#edit_cycle_regular").prop('checked',true) : $("#edit_cycle_regular").prop('checked',false);
            res.data[0].general_weight_loss=='1' ? $("#edit_general_weight_loss").prop('checked',true) : $("#edit_general_weight_loss").prop('checked',false);
            res.data[0].general_fatigue=='1' ? $("#edit_general_fatigue").prop('checked',true) : $("#edit_general_fatigue").prop('checked',false);
            res.data[0].breast_lump=='1' ? $("#edit_breast_lump").prop('checked',true) : $("#edit_breast_lump").prop('checked',false);
            res.data[0].breast_pain=='1' ? $("#edit_breast_pain").prop('checked',true) : $("#edit_breast_pain").prop('checked',false);
            res.data[0].breast_discharge=='1' ? $("#edit_breast_discharge").prop('checked',true) : $("#edit_breast_discharge").prop('checked',false);
            res.data[0].breast_skin_changes=='1' ? $("#edit_breast_skin_changes").prop('checked',true) : $("#edit_breast_skin_changes").prop('checked',false);
            res.data[0].inspection_asymmetry=='1' ? $("#edit_inspection_asymmetry").prop('checked',true) : $("#edit_inspection_asymmetry").prop('checked',false);
            res.data[0].inspection_skin_changes=='1' ? $("#edit_inspection_skin_changes").prop('checked',true) : $("#edit_inspection_skin_changes").prop('checked',false);
            res.data[0].inspection_nipple_changes=='1' ? $("#edit_inspection_nipple_changes").prop('checked',true) : $("#edit_inspection_nipple_changes").prop('checked',false);
            res.data[0].lump_tenderness_rv=='1' ? $("#edit_lump_tenderness_rv").prop('checked',true) : $("#edit_lump_tenderness_rv").prop('checked',false);
            res.data[0].surgical_scars=='1' ? $("#edit_surgical_scars").prop('checked',true) : $("#edit_surgical_scars").prop('checked',false);
            res.data[0].age_risk=='1' ? $("#edit_age_risk").prop('checked',true) : $("#edit_age_risk").prop('checked',false);
            res.data[0].family_history=='1' ? $("#edit_family_history").prop('checked',true) : $("#edit_family_history").prop('checked',false);
            res.data[0].genetic_factors=='1' ? $("#edit_genetic_factors").prop('checked',true) : $("#edit_genetic_factors").prop('checked',false);
            res.data[0].hormonal_exposure=='1' ? $("#edit_hormonal_exposure").prop('checked',true) : $("#edit_hormonal_exposure").prop('checked',false);
            res.data[0].previous_benign_disease=='1' ? $("#edit_previous_benign_disease").prop('checked',true) : $("#edit_previous_benign_disease").prop('checked',false);

           
           
            $("#edit_gender").val(res.data[0].gender);
            $("#edit_dob").val(res.data[0].patient_date_of_birth);
            $("#edit_blood_group").val(res.data[0].blood_group);
            $("#edit_allergies").val(res.data[0].allergies);
            $("#edit_company_name").val(res.data[0].company_name);
            $("#edit_occupation").val(res.data[0].occupation);
            var age = calculateAge(new Date(res.data[0].patient_date_of_birth));
            $('.editage').text(age);

            var insurance       = res.data[0].insurance;
            var company_id_fk   = res.data[0].company_id_fk;

            if (insurance == 'Share Holder' || insurance == 'Insurance covered' || insurance == 'Pre Employment') {
                $price_profile = 'cost price';
            }else if (company_id_fk > 0 ){
                $price_profile = 'company price';
                if (company_id_fk==7) { // for OPHKL Company
                    $price_profile = 'ophkl price';
                }
            }else{
                $price_profile = 'alliance price';
            }

            console.log($price_profile)



            var data = {
                id: res.data[0].patient_id_fk,
                text: res.data[0].patient_full_name
            };

            if ($('#edit_patient_id_fk').find("option[value='" + data.id + "']").length) {
                $('#edit_patient_id_fk').val(data.id).trigger('change');
            } else { 
                // Create a DOM Option and pre-select by default
                var newOption = new Option(data.text, data.id, true, true);
                // Append it to the select
                $('#edit_patient_id_fk').append(newOption).trigger('change');
            } 

            
       
            $('.bootstrap-select').selectpicker('refresh')

            
            
            $('#edit_form_cont').modal('toggle');      

        }else{

          swal({
                  title: i18n.t("Error"),
                  text: i18n.t(res.data),
                  confirmButtonColor: "#2196F3",
                  type: "error"
              });

        }
        
      }
    });


}


function view(itemid){
  

    $("#edit_form")[0].reset();

    $("#edited_id").val(itemid);
 

    $.ajax({
      url: "models/crul_breast_clinic.php",
      type:"POST",
      dataType : "JSON",
      data:{   "type":"get_edit",
                "edited_id":itemid,
                
            } ,
      complete:function(){
        
      },
      beforeSend:function(){
        
      },
      success: function(res) {


        if(res.is_success == true){

            var $tr = `

                        <div class="table-responsive1">
                            <table id="header_table" class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; ">
                                <tbody>
                                    <tr >
                                        <td rowspan=2 width=20%><img style="width:100px;" src="${COMPANY_LOGO}"></td>
                                        <td width=55%>${COMPANY_NAME}</td>
                                        <td width=25%  style="text-align:start;">Date: ${res.data[0].breast_clinic_date}</td>
                                    </tr>
                                    <tr >
                                        <td>Breast Clinic Assessment</td>
                                        <td style="text-align:start;">Reference No.:${res.data[0].breast_clinic_reference_number}</td>
                                    </tr>
                                    
                                </tbody>
                            </table>
                            <br>
                            <table id="patient_table_id" class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; text-align:left;" >
                                <tbody>

                                    <tr >
                                        <td colspan=6 data-i18n="page.patient_report.pn" style="text-align:center !important;">
                                            BREAST CLINIC HISTORY SHEET
                                        </td>
                                        
                                    </tr>


                                    <tr >
                                        <td data-i18n="page.patient_report.pn">
                                            Surename:
                                        </td>
                                        <td colspan="2">
                                            ${res.data[0].third_name}                                            
                                        </td>

                                        <td data-i18n="page.patient_report.pn">
                                            Forename(s):
                                        </td>
                                        <td colspan="2">
                                            ${res.data[0].first_name}                                            
                                        </td>
                                    </tr>

                                    <tr class="border ">
                                        <td data-i18n="page.patient_report.pn">
                                            Date of Birth
                                        </td>
                                        <td>
                                            ${res.data[0].patient_date_of_birth}
                                        </td>

                                        <td data-i18n="page.patient_report.pn">
                                            (yyyy-mm-dd)
                                        </td>
                                        <td>
                                            ${res.data[0].gender}
                                        </td>

                                        <td data-i18n="page.patient_report.pn">
                                            Patient ID
                                        </td>
                                        <td>
                                            ${res.data[0].patient_id_fk}
                                        </td>

                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn">
                                            Contact Address:
                                        </td>
                                        
                                        <td colspan="5">
                                            ${res.data[0].patient_address}
                                        </td>

                                    

                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn">
                                            Contact telephone /email
                                        </td>
                                        <td colspan="2">
                                            ${res.data[0].patient_phone}
                                        </td>

                                        <td data-i18n="page.patient_report.pn">
                                            /
                                        </td>
                                        <td colspan="2">
                                            ${res.data[0].patient_email}
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn">
                                            G.P./Doctor:
                                        </td>
                                        <td colspan="5">
                                            ${res.data[0].g_p_doctor}
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn">
                                            Contact No (ideally cell phone) + country code
                                        </td>
                                        <td >
                                            ${res.data[0].patient_phone}
                                        </td>

                                        <td data-i18n="page.patient_report.pn">
                                            Company
                                        </td>
                                        <td >
                                            ${res.data[0].company_name}
                                        </td>

                                        <td data-i18n="page.patient_report.pn">
                                            Occupation
                                        </td>
                                        <td >
                                            ${res.data[0].occupation}
                                        </td>
                                    </tr>

                                </tbody>
                            </table>
                            <br>
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td rowspan=6 data-i18n="page.patient_report.pn" style="text-align:center;">
                                            Presenting Complaint
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            Main complaint:
                                        </td>
                                    
                                        <td data-i18n="page.patient_report.pn" style="width:70%; ">
                                            ${res.data[0].main_complaint}
                                        </td>
                                        
                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn">
                                            Duration:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            ${res.data[0].duration}
                                        </td>
                                        
                                    </tr>



                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn" =>
                                            Laterality (Right / Left / Both):
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            ${res.data[0].laterality}
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn" >
                                            Progression/Changes:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            ${res.data[0].progression}
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn" >
                                            Associated symptoms:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            <i class="icon-checkbox-${res.data[0].pain=='1' ? 'checked' :'unchecked'}"></i> Pain
                                            <i class="icon-checkbox-${res.data[0].nipple_discharge=='1' ? 'checked' :'unchecked'}"></i> Nipple discharge
                                            <i class="icon-checkbox-${res.data[0].skin_changes=='1' ? 'checked' :'unchecked'}"></i> Skin changes

                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn" >
                                            Systemic symptoms:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            <i class="icon-checkbox-${res.data[0].systemic_weight_loss=='1' ? 'checked' :'unchecked'}"></i> Weight loss
                                            <i class="icon-checkbox-${res.data[0].systemic_fever=='1' ? 'checked' :'unchecked'}"></i> Fever
                                            <i class="icon-checkbox-${res.data[0].systemic_fatigue=='1' ? 'checked' :'unchecked'}"></i> Fatigue

                                        </td>
                                    </tr>



                                    
                                </tbody>
                            </table>
                            <br>
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td rowspan=5 data-i18n="page.patient_report.pn" >
                                            History of Present Illness
                                        </td>
                                        <td data-i18n="page.patient_report.pn" >
                                            Lump details:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            Size: ${res.data[0].lump_size}, 
                                            Location: ${res.data[0].lump_location}, 
                                            Mobility: ${res.data[0].lump_mobility}, 
                                            <i class="icon-checkbox-${res.data[0].lump_tenderness=='1' ? 'checked' :'unchecked'}"></i> Tenderness

                                        </td>

                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn" >
                                            Nipple discharge:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            Color: ${res.data[0].discharge_color}, 
                                            Consistency: ${res.data[0].discharge_consistency}, 
                                            <i class="icon-checkbox-${res.data[0].discharge_side=='1' ? 'checked' :'unchecked'}"></i> Tenderness

                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn" >
                                            Pain:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            Character: ${res.data[0].pain_character}, 
                                            Timing: ${res.data[0].pain_timing}, 
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn" >
                                            Skin changes:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            <i class="icon-checkbox-${res.data[0].skin_redness=='1' ? 'checked' :'unchecked'}"></i> Redness
                                            <i class="icon-checkbox-${res.data[0].skin_dimpling=='1' ? 'checked' :'unchecked'}"></i> Dimpling
                                            <i class="icon-checkbox-${res.data[0].skin_ulceration=='1' ? 'checked' :'unchecked'}"></i> Ulceration

                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn" >
                                            History of infections:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            <i class="icon-checkbox-${res.data[0].infections=='1' ? 'checked' :'unchecked'}"></i> Infections
                                            <i class="icon-checkbox-${res.data[0].trauma=='1' ? 'checked' :'unchecked'}"></i> Trauma
                                            <i class="icon-checkbox-${res.data[0].previous_surgeries=='1' ? 'checked' :'unchecked'}"></i> previous surgeries

                                        </td>
                                    </tr>

                                    

                                </tbody>
                            </table>
                             <br>
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td rowspan=2 data-i18n="page.patient_report.pn" >
                                            Past Medical History
                                        </td>
                                        <td data-i18n="page.patient_report.pn" >
                                            Breast disease:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            <i class="icon-checkbox-${res.data[0].benign_lumps=='1' ? 'checked' :'unchecked'}"></i> Benign lumps
                                            <i class="icon-checkbox-${res.data[0].mastitis=='1' ? 'checked' :'unchecked'}"></i> Mastitis 
                                            <i class="icon-checkbox-${res.data[0].biopsies_surgery=='1' ? 'checked' :'unchecked'}"></i> Biopsies/Surgery
                                        </td>

                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn" >
                                            Chronic illnesses:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            <i class="icon-checkbox-${res.data[0].diabetes=='1' ? 'checked' :'unchecked'}"></i> Diabetes 
                                            <i class="icon-checkbox-${res.data[0].hypertension=='1' ? 'checked' :'unchecked'}"></i> Hypertension  
                                            <i class="icon-checkbox-${res.data[0].thyroid=='1' ? 'checked' :'unchecked'}"></i> Thyroid  
                                            Other: ${res.data[0].other_conditions}

                                        </td>
                                    </tr>

                                    
                                    

                                </tbody>
                            </table>
                             <br>

                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td rowspan=2 data-i18n="page.patient_report.pn" >
                                            Medications
                                        </td>
                                        <td data-i18n="page.patient_report.pn" >
                                            Current medications:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            ${res.data[0].current_medications}

                                        </td>

                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn" >
                                            Hormonal therapy (OC/HRT):
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            ${res.data[0].hormonal_therapy}

                                        </td>
                                    </tr>

                                    
                                    

                                </tbody>
                            </table>
                             <br>

                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td rowspan=2 data-i18n="page.patient_report.pn" >
                                            Allergies
                                        </td>
                                        <td data-i18n="page.patient_report.pn" >
                                            Drugs:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            ${res.data[0].drug_allergies}

                                        </td>

                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn" >
                                            Others:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            ${res.data[0].other_allergies}

                                        </td>
                                    </tr>

                                </tbody>
                            </table>
                             <br>


                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td rowspan=3 data-i18n="page.patient_report.pn" >
                                            Family History
                                        </td>
                                        <td data-i18n="page.patient_report.pn" >
                                            Breast cancer:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                             Relation ${res.data[0].breast_cancer_relation} & age at diagnosis ${res.data[0].breast_cancer_age} 

                                        </td>

                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn" >
                                            Ovarian/other cancers:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                             Relation ${res.data[0].ovarian_cancer_relation} & age ${res.data[0].ovarian_cancer_age} 

                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn" >
                                            Genetic syndromes:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            ${res.data[0].genetic_syndromes}
                                        </td>
                                    </tr>

                                </tbody>
                            </table>
                             <br>

                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td rowspan=4 data-i18n="page.patient_report.pn" >
                                            Gynecological / Reproductive History
                                        </td>
                                        <td data-i18n="page.patient_report.pn" >
                                            Menstrual history:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                             Age at menarche: ${res.data[0].menarche_age}, <i class="icon-checkbox-${res.data[0].cycle_regular=='1' ? 'checked' :'unchecked'}"></i> Regularity, Last period: ${res.data[0].last_period} 
                                        </td>

                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn" >
                                            Pregnancy:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                              Number of pregnancies: ${res.data[0].pregnancies},  Live births: ${res.data[0].live_births} , Breastfeeding history: ${res.data[0].breastfeeding_history} 
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn" >
                                            Menopause:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            ${res.data[0].menopause_age}
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn" >
                                            Hormonal therapy or contraception:
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            ${res.data[0].hormonal_contraception}
                                        </td>
                                    </tr>

                                </tbody>
                            </table>
                             <br>


                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn">
                                            <b>EMPLOYEE PEHA CERTIFICATE</b>
                                            <br>
                                        </td>
                                        
                                    </tr>
                                    
                                </tbody>
                            </table>
                            
                            <br>
                            <center>Report on Health Assessment – Examining Medical Officer to complete</center>
                            <br>
                            <b>Employees Details</b>
                            <br>
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn">
                                            Surename
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            First (middle) name(s)
                                        </td>
                                        
                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn">
                                            ${res.data[0].third_name}
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            ${res.data[0].patient_full_name}
                                        </td>
                                        
                                    </tr>
                                    
                                </tbody>
                            </table>

                            <br>
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn">
                                            Employer
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            Work Site
                                        </td>
                                        
                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn">
                                            ${res.data[0].employer}
                                        </td>
                                        <td data-i18n="page.patient_report.pn">
                                            ${res.data[0].work_site}
                                        </td>
                                        
                                    </tr>
                                    
                                </tbody>
                            </table>
                            
                            <table id="footer_1" class="table hidden table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:99%; ">
                                <tbody>
                                    
                                    <tr >
                                        <td colspan=2 style="border:0px; text-align:center;">Page 1 of 5</td>
                                    </tr>
                                    <tr >
                                        <td style=" border:0px;">Provided by ${COMPANY_WEBSITE}</td>
                                        <td style="text-align:end; border:0px;">Version 3: 2025</td>

                                    </tr>
                                </tbody>
                            </table> 

                            <table id="footer_2" class="table hidden table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:99%; ">
                                <tbody>
                                    
                                    <tr >
                                        <td colspan=2 style="border:0px; text-align:center;">Page 2 of 5</td>
                                    </tr>
                                    <tr >
                                        <td style=" border:0px;">Provided by ${COMPANY_WEBSITE}</td>
                                        <td style="text-align:end; border:0px;">Version 3: 2025</td>

                                    </tr>
                                </tbody>
                            </table>

                            <table id="footer_3" class="table hidden table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:99%; ">
                                <tbody>
                                    
                                    <tr >
                                        <td colspan=2 style="border:0px; text-align:center;">Page 3 of 5</td>
                                    </tr>
                                    <tr >
                                        <td style=" border:0px;">Provided by ${COMPANY_WEBSITE}</td>
                                        <td style="text-align:end; border:0px;">Version 3: 2025</td>

                                    </tr>
                                </tbody>
                            </table> 

                            <table id="footer_4" class="table hidden table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:99%; ">
                                <tbody>
                                    <tr >
                                        <td colspan=2 style="border:0px; text-align:center;">Page 4 of 5</td>
                                    </tr>
                                    <tr >
                                        <td style=" border:0px;">Provided by ${COMPANY_WEBSITE}</td>
                                        <td style="text-align:end; border:0px;">Version 3: 2025</td>
                                    </tr>
                                </tbody>
                            </table> 

                            <table id="footer_5" class="table hidden table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:99%; ">
                                <tbody>
                                    
                                    <tr >
                                        <td colspan=2 style="border:0px; text-align:center;">Page 5 of 5</td>
                                    </tr>
                                    <tr >
                                        <td style=" border:0px;">Provided by ${COMPANY_WEBSITE}</td>
                                        <td style="text-align:end; border:0px;">Version 3: 2025</td>

                                    </tr>
                                </tbody>
                            </table> 
                        </div>

                         `;

            
            $("#view-title").html("Occupational Health Assessment");
            $("#view_table").html($tr);
            $("#mpdf_btn").html(`<a class="btn btn-success pull-left legitRipple btn-labeled btn-labeled-left" href="models/crul_pdf.php?type=merege_pdf_checkup&edited_id=${itemid}&company_name=${COMPANY_NAME}&company_logo=${COMPANY_LOGO}&company_website=${COMPANY_WEBSITE}" target="_blank">Print PDF<b><i class="icon-file-pdf"></i></b></a>`);
            
            $('#view-modal').modal('toggle');      

        }else{

          swal({
                  title: i18n.t("Error"),
                  text: i18n.t(res.data),
                  confirmButtonColor: "#2196F3",
                  type: "error"
              });

        }
        
      }
    });


}

function view_lab(itemid){
  

    $("#edit_form")[0].reset();

    $("#edited_id").val(itemid);
 

    $.ajax({
      url: "models/crul_breast_clinic.php",
      type:"POST",
      dataType : "JSON",
      data:{   "type":"get_edit",
                "edited_id":itemid,
                
            } ,
      complete:function(){
        
      },
      beforeSend:function(){
        
      },
      success: function(res) {


        if(res.is_success == true){


            var $lab =``;
            var $rad =``;
            var $trt =``;
            var l=0;
            var r=0;
            var t=0;
            
            for (var i = 0; i < res.lab.length; i++) {

                if (res.lab[i].lab_test_id > 0) {
                    t++;

                    var $detail_param = ``;

                    //total_price = +total_price + +res.data[i].sell;

                    if (res.detail.length>0) {
                        for (var j = 0; j < res.detail.length; j++) {

                            if (res.lab[i].lab_test_detail_id == res.detail[j].lab_test_detail_id_fk) {

                                $detail_param+=`<tr class="clone_row">
                                                <td class="brdless"><i class="icon-arrow-right15 text-primary"></i></td>
                                                <td class="brdless productname">
                                                    ${res.detail[j].product_detail_name}
                                                </td>

                                                <td class="brdless">
                                                    ${res.detail[j].item_test_result}
                                                </td>

                                                <td class="brdless refvalue">
                                                    <span style="white-space: pre-line">${res.detail[j].detail_reference_value}</span>
                                                </td>

                                                <td class="brdless">
                                                    ${res.detail[j].detail_test_unit}
                                                </td>

                                                <td class="brdless">
                                                    ${res.detail[j].item_test_note}
                                                </td>

                                                
                                                <td class="brdless">
                                                    
                                                </td>
                                                
                                            </tr>`
                            } 
                        }
                    }else{
                        for (var j = 0; j < res.normal.length; j++) {

                            if (res.data[i].lab_test_detail_id == res.normal[j].lab_test_detail_id) {


                                $detail_param+=`<tr class="clone_row">
                                                <td class="brdless" class="bg-ping-400"><i class="icon-arrow-right15 text-primary"></i></td>
                                                <td class="brdless" style="text-align:left; padding-left:15px;">
                                                    ${res.normal[j].product_detail_name}
                                                </td>

                                                <td class="brdless">
                                                </td>

                                                <td class="brdless">
                                                    <span style="white-space: pre-line">${res.normal[j].reference_value}</span>
                                                </td>

                                                <td class="brdless">
                                                    ${res.normal[j].detail_test_unit}
                                                </td>

                                                <td class="brdless">
                                                </td>

                                                
                                                <td class="brdless">
                                                    
                                                </td>
                                                
                                            </tr>`
                            } 
                        }
                    }


                    // $trt+=`<tr class="clone_row">
                    //                 <td>${t}</td>
                    //                 <td>
                    //                     ${res.lab[i].product_name}
                    //                 </td>
                    //                 <td>
                    //                     ${res.lab[i].test_result}
                    //                 </td>
                    //                 <td>
                    //                    ${res.lab[i].test_unit}
                    //                 </td>
                    //                 <td>
                    //                     ${res.lab[i].reference_value}
                    //                 </td>
                    //                 <td>
                    //                     ${res.lab[i].test_note}
                    //                 </td>

                    //                 <td>
                    //                 </td>
                                    
                    //             </tr>`;
                                $trt+=`<tr class="clone_row maintd" style="border: 1px solid !important;">
                                    <td class="brdless" colspan="6">
                                        <div style="border: 1px solid #9d9b9b !important;"><table style="width: 100%;">
                                           
                                        <tr>
                                                <td class="brdless" style="width: 40px;">${t}</td>
                                                <td class="brdless" style="width: 305px;">
                                                    ${res.lab[i].product_name}
                                                </td>
                                                <td class="brdless" style="width: 170px;">
                                                    ${res.lab[i].test_result}
                                                    <a class="hidden-attach" href="${res.lab[i].attach_file}" target="_blank">
                                                        ${res.lab[i].attach_file != null ? '<i class="icon-file-check2 text-success icon-2x"></i>' : ''}
                                                    </a>
                                                </td>
                                                <td class="brdless" style="width: 360px;">
                                                    <span style="white-space: pre-line">${res.lab[i].reference_value}</span>
                                                </td>
                                                <td class="brdless" style="width: 100px;">
                                                   ${res.lab[i].test_unit}
                                                </td>
                                            </tr>
                                            ${$detail_param}
                                            <tr>
                                                <td><b>Remarks:</b></td>
                                                <td class="brdless" style="text-align:left;width: 100px;padding:10px !important;" colspan="6">
                                                    ${res.lab[i].test_note}
                                                </td>
                                            </tr>
                                        </table>
                                        </div>
                                    </td>
                                </tr>`;
                
                }
            }


            var $tr = `<div class="table-responsive1">
                            <table id="header_table" class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; ">
                                <tbody>
                                    <tr >
                                        <td rowspan=2 width=20%><img style="width:100px;" src="${COMPANY_LOGO}"></td>
                                        <td width=55%>${COMPANY_NAME}</td>
                                        <td width=25%  style="text-align:start;">Date: ${res.lab[0].lab_test_date}</td>
                                    </tr>
                                    <tr >
                                        <td>Lab Report</td>
                                        <td style="text-align:start;">Reference No.:${res.lab[0].test_number}</td>
                                    </tr>
                                    
                                </tbody>
                            </table>
                            <br>
                            <table id="patient_table_id" class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; text-align:left;" >
                                <tbody>
                                    <tr >
                                        <td data-i18n="page.patient_report.pn">
                                            To Doctor
                                        </td>
                                        <td colspan="5">
                                            ${res.lab[0].site_doctor}                                            
                                        </td>
                                    </tr>

                                    <tr >
                                        <td data-i18n="page.patient_report.pn">
                                            Patient Name
                                        </td>
                                        <td colspan="5">
                                            ${res.lab[0].patient_full_name}                                            
                                        </td>
                                        <td >
                                            Patient ID
                                        </td>
                                        <td >
                                            ${res.data[0].patient_id_fk}
                                        </td>
                                    </tr>

                                    <tr class="border ">
                                        <td data-i18n="page.patient_report.pn">
                                            Sample Date
                                        </td>
                                        <td>
                                            ${res.lab[0].lab_test_date}
                                        </td>

                                        <td data-i18n="page.patient_report.pn">
                                            Gender
                                        </td>
                                        <td>
                                            ${res.lab[0].gender}
                                        </td>

                                        <td data-i18n="page.patient_report.pn">
                                            DOB
                                        </td>
                                        <td>
                                            ${res.lab[0].patient_date_of_birth}
                                        </td>
                                        <td class="font-bold">
                                            Age
                                        </td>
                                        <td>
                                            ${calculateAge(res.data[0].patient_date_of_birth)}
                                        </td>

                                    </tr>
                                    <!--
                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn">
                                            Blood Group
                                        </td>
                                        <td>
                                            ${res.lab[0].blood_group}
                                        </td>

                                        <td data-i18n="page.patient_report.pn">
                                            Allergies
                                        </td>
                                        <td colspan="5">
                                            ${res.lab[0].allergies}
                                        </td>

                                    

                                    </tr>

                                    <tr class="border">
                                        <td data-i18n="page.patient_report.pn">
                                            Company
                                        </td>
                                        <td>
                                            ${res.lab[0].company_name}
                                        </td>

                                        <td data-i18n="page.patient_report.pn">
                                            Occupation
                                        </td>
                                        <td >
                                            ${res.lab[0].occupation}
                                        </td>
                                        <td >
                                            Patient ID
                                        </td>
                                        <td colspan="3">
                                            ${res.lab[0].patient_id_fk}
                                        </td>

                                    

                                    </tr>
                                    -->
                                </tbody>
                            </table>
                            <br>
                            
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; ">
                                <tbody>
                                    
                                    <tr class=" bg-primary">
                                        <td>#</td>
                                        <td >Lab Test</td>
                                        <td >Result</td>
                                        <td >Units</td>
                                        <td >Reference Values</td>
                                        <td >Note</td>
                                        <td >Other</td>
                                    </tr>
                                    ${$trt}
                                    <tr >
                                        <td colspan=7><br></td>
                                    </tr>
                                    <tr style="display:none;">
                                        <td>Conclusion</td>
                                        <td colspan=6>${res.lab[0].result_conclusion}</td>
                                    </tr>
                                    <tr style="display:none;">
                                        <td>Other Notes</td>
                                        <td colspan=6>${res.lab[0].result_note}</td>
                                    </tr>          
                                </tbody>
                            </table>

                            <br>    
                            <table id="footer_first" class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:99%; ">
                                <tbody>
                                    
                                    <tr >
                                        <td width=20% style="border:0px;">Doctor:</td>
                                        <td style="text-align:left; border:0px;"></td>

                                    </tr>
                                    <tr >
                                        <td width=25% style=" border:0px;">Signature and Stamp:</td>
                                        <td style="text-align:end; border:0px;">Page 1 of 1</td>

                                    </tr>
                                </tbody>
                            </table> 
                        </div>

                         `;

            


            
            $("#view-title").html("Patient Report");
            $("#view_table").html($tr);
            
            $('#view-modal').modal('toggle');      

        }else{

          swal({
                  title: i18n.t("Error"),
                  text: i18n.t(res.data),
                  confirmButtonColor: "#2196F3",
                  type: "error"
              });

        }
        
      }
    });


}

function view_radiology(itemid){
  

    $("#edit_form")[0].reset();

    $("#edited_id").val(itemid);
 

    $.ajax({
      url: "models/crul_breast_clinic.php",
      type:"POST",
      dataType : "JSON",
      data:{   "type":"get_edit",
                "edited_id":itemid,
                
            } ,
      complete:function(){
        
      },
      beforeSend:function(){
        
      },
      success: function(res) {


        if(res.is_success == true){


            var $radiology =``;
            var $rad =``;
            var $trt =``;
            var l=0;
            var r=0;
            var t=0;
            
            for (var i = 0; i < res.radiology.length; i++) {

                if (res.radiology[i].radiology_test_id > 0) {
                    t++;


                    $trt+=`<tr class="clone_row">
                                    <td>${t}</td>
                                    <td>
                                        ${res.radiology[i].product_name}
                                    </td>
                                    <td>
                                        ${res.radiology[i].test_result}
                                    </td>
                                    <td style="display:none;">
                                       ${res.radiology[i].test_unit}
                                    </td>
                                    <td style="display:none;">
                                        ${res.radiology[i].reference_value}
                                    </td>
                                    <td>
                                        ${res.radiology[i].test_note}
                                    </td>
                                    <td>
                                        <a class="hidden-attach" href="${res.radiology[i].attach_file}" target="_blank">
                                            ${res.radiology[i].attach_file!=null?'<i class="icon-file-check2 text-success icon-2x"></i>':'<i class=" icon-file-minus2 text-danger icon-2x"></i>'}
                                        </a>
                                    </td>
                                </tr>`;
                
                }
            }


            var $tr = `<div class="table-responsive1">
                            <table id="header_table" class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; ">
                                <tbody>
                                    <tr >
                                        <td rowspan=2 width=20%><img style="width:100px;" src="${COMPANY_LOGO}"></td>
                                        <td width=55%>${COMPANY_NAME}</td>
                                        <td width=25% style="text-align:start;">Date: ${res.radiology[0].radiology_test_date}</td>
                                    </tr>
                                    <tr >
                                        <td>Radiology Report</td>
                                        <td style="text-align:start;">Reference No.:${res.radiology[0].test_number}</td>
                                    </tr>
                                    
                                </tbody>
                            </table>
                            <br>
                            <table id="patient_table_id" class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; text-align:left; " >
                                <tbody>
                                    <tr >
                                        <td data-i18n="page.patient_report.pn">
                                            To Doctor
                                        </td>
                                        <td colspan="5">
                                            ${res.radiology[0].site_doctor}                                            
                                        </td>
                                    </tr>

                                    <tr >
                                        <td data-i18n="page.patient_report.pn">
                                            Patient Name
                                        </td>
                                        <td colspan="5">
                                            ${res.radiology[0].patient_full_name}                                            
                                        </td>
                                        <td >
                                            Patient ID
                                        </td>
                                        <td >
                                            ${res.data[0].patient_id_fk}
                                        </td>
                                    </tr>

                                    <tr >
                                        <td data-i18n="page.patient_report.pn">
                                            Sample Date
                                        </td>
                                        <td>
                                            ${res.radiology[0].radiology_test_date}
                                        </td>

                                        <td data-i18n="page.patient_report.pn">
                                            Gender
                                        </td>
                                        <td>
                                            ${res.radiology[0].gender}
                                        </td>

                                        <td data-i18n="page.patient_report.pn">
                                            DOB
                                        </td>
                                        <td>
                                            ${res.radiology[0].patient_date_of_birth}
                                        </td>
                                        <td class="font-bold">
                                            Age
                                        </td>
                                        <td>
                                            ${calculateAge(res.data[0].patient_date_of_birth)}
                                        </td>

                                    </tr>
                                    <!--
                                    <tr >
                                        <td data-i18n="page.patient_report.pn">
                                            Blood Group
                                        </td>
                                        <td>
                                            ${res.radiology[0].blood_group}
                                        </td>

                                        <td data-i18n="page.patient_report.pn">
                                            Allergies
                                        </td>
                                        <td colspan="3">
                                            ${res.radiology[0].allergies}
                                        </td>

                                    

                                    </tr>

                                    <tr >
                                        <td data-i18n="page.patient_report.pn">
                                            Company
                                        </td>
                                        <td>
                                            ${res.radiology[0].company_name}
                                        </td>

                                        <td data-i18n="page.patient_report.pn">
                                            Occupation
                                        </td>
                                        <td >
                                            ${res.radiology[0].occupation}
                                        </td>
                                        <td >
                                            Patient ID
                                        </td>
                                        <td >
                                            ${res.radiology[0].patient_id_fk}
                                        </td>

                                    

                                    </tr>
                                    -->
                                </tbody>
                            </table>
                            <br>
                            
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; ">
                                <tbody>
                                    
                                    <tr class=" bg-primary">
                                        <td width=5%>#</td>
                                        <td >Study Name</td>
                                        <td >Result</td>
                                        <td style="display:none;">Units</td>
                                        <td style="display:none;">Reference Values</td>
                                        <td >Note</td>
                                        <td >Attach</td>
                                    </tr>
                                    ${$trt}
                                    <tr >
                                        <td colspan=6><br></td>
                                    </tr>

                                    <tr >
                                        <td>Report</td>
                                        <td colspan=5>${res.radiology[0].result_note}</td>
                                    </tr>   

                                    <tr >
                                        <td>Conclusion</td>
                                        <td colspan=5>${res.radiology[0].result_conclusion}</td>
                                    </tr>
                                           
                                </tbody>
                            </table>

                            <br>    
                            <table id="footer_first" class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:99%; ">
                                <tbody>
                                    
                                    <tr >
                                        <td width=20% style="border:0px;">Doctor:</td>
                                        <td style="text-align:left; border:0px;">${res.radiology[0].lab_doctor}</td>

                                    </tr>
                                    <tr >
                                        <td width=25% style=" border:0px;">Signature and Stamp:</td>
                                        <td style="text-align:end; border:0px;">Page 1 of 1</td>

                                    </tr>
                                </tbody>
                            </table> 
                        </div>

                         `;

            


            
            $("#view-title").html("Patient Report");
            $("#view_table").html($tr);
            
            $('#view-modal').modal('toggle');      

        }else{

          swal({
                  title: i18n.t("Error"),
                  text: i18n.t(res.data),
                  confirmButtonColor: "#2196F3",
                  type: "error"
              });

        }
        
      }
    });


}



function delete_items(itemid) {
    // bootstrap modal confirmation box
    swal({
        title: i18n.t("Are you Sure!"),
        text: i18n.t("Record Will be Deleted Permenantly!, You Can't Restore it again."),
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#EF5350",
        cancelButtonColor: "#EF5350",
        confirmButtonText: i18n.t("Yes delete it"),
        cancelButtonText: i18n.t("Cancel"),
        closeOnConfirm: false,
        closeOnCancel: true
    },
    function(isConfirm){
        if (isConfirm) {
          $.ajax({
            url: "models/crul_breast_clinic.php",
            type:"POST",
            dataType : "JSON",
            data: {"type":"delete","obj_id":itemid} ,
            complete:function(){
             
            },
            beforeSend:function(){
             
            },
            success: function(res) {

              if(res.is_success == true){
                swal({
                        title: i18n.t("Deleted!"),
                        text: i18n.t(res.data),
                        confirmButtonColor: "#66BB6A",
                        type: "success"
                    });
                $(".datatable-column-search-inputs").DataTable().ajax.reload(null, false);
              }else{
                swal({
                        title: "Cancelled",
                        text: i18n.t(res.data),
                        confirmButtonColor: "#2196F3",
                        type: "error"
                    });
              }
            }
        });
        }
    }); // /confirm
}


function set_status(itemid){
    $("#status_form")[0].reset();
    $("#status_id").val(itemid);
    $('#status_form_cont').modal('toggle');
}



function get_Doctors(){

        $.ajax({
                    url : 'models/crul_user.php',
                    type : 'POST',
                    data : {type:'get'},
                    dataType : 'json',
                    success : function(res) {
                            var attach =`<option value="0">${i18n.t('Select Doctor')}</option>`;
                          
                            for(var i=0 ; i < res.data.length ;i++){
                              
                              attach+=`<option value="${res.data[i].staff_id}">${res.data[i].full_name}</option>`;
                             
                            }


                            $("#staff_id_fk").html(attach);
                            $('#staff_id_fk').selectpicker('refresh');

                            $("#edit_staff_id_fk").html(attach);
                            $('#edit_staff_id_fk').selectpicker('refresh');

                    },
                    complete: function() {
                             //  me.data('requestRunning', false);
                    }

        }); // submit ajax

}




function setText_arr(element,prefix,$tr){
        console.log(prefix)
        var value = $(element).text();
        $tr.find(`#${prefix}\\[\\]`).val(value);
        $tr.find(`#${prefix}\\[\\]`).trigger('change');
        $tr.find(`#searchResult\\[\\]`).empty();

}

function print(id) {

    attach = $(`#${id}`).html();
    var style = `<style>
                    td {
                        text-align:left;
                        border-left: 0.25px solid #9d9b9b;
                        border-bottom: 0.25px solid #9d9b9b;
                        height:30px;
                    }

                    #patient_table_id td {
                        text-align:left !important;
                        border-left: 0px solid #9d9b9b !important;

                    }

                    #header_table td {
                        border: 0px solid #9d9b9b;
                    }
                    
                    .bg-primary{
                        background-color:grey;
                    }

                    #footer_1{
                                                
                                        position:absolute;
                                        top:25.7cm;
                                        width: -webkit-fill-available;

                                  }

                    #footer_2{
                                                
                                        position:absolute;
                                        top:54cm;
                                        width: -webkit-fill-available;

                                  }

                    #footer_3{
                                                
                                        position:absolute;
                                        top:81cm;
                                        width: -webkit-fill-available;

                                  }

                    #footer_4{
                                                
                                        position:absolute;
                                        top:109cm;
                                        width: -webkit-fill-available;

                                  }

                    #footer_5{
                                                
                                        position:absolute;
                                        top:136.5cm;
                                        width: -webkit-fill-available;

                                  }

                    page[size="A4"] {  
                                    width: 21cm;
                                    height: 29.7cm; 
                                  }
                                  
                                  
                      page[size="A5"] {
                        width: 14.8cm;
                        height: 21cm;
                      }
                      page[size="A5"][layout="landscape"] {
                        width: 21cm;
                        height: 14.8cm;  
                      }

                      .break-page{
                        page-break-after:always;
                      }

                      #header{
                        position:fixed;
                        top:1.5cm;
                        
                      }

                      

                      @media print {
                        body, page {
                          margin: 0;
                          box-shadow: 0;
                        }


                      }

                     

                      #footer{
                        
                            position:absolute;
                            top:57.8cm;
                            width: -webkit-fill-available;
                        
                      }


                </style>
                <link href="assets/css/icons/icomoon/styles.css" rel="stylesheet" type="text/css">

                <script>

                  setTimeout(function() {
                    window.print()
                  }, 2000)
                  
                </script>`;       
    window.open().document.write(style+attach);
    
    
}

function get_patient_report(id){

    $.ajax({
                url : 'models/crul_breast_clinic.php',
                type : 'POST',
                data : {type:'getcheckup',id:id},
                dataType : 'json',
                success : function(res) {
                        var attach =``;
                      
                        for(var i=0 ; i < res.data.length ;i++){
                          if (res.data[i].patient_report_id > 0) {
                            attach+=`<a onclick="view_report(${res.data[i].patient_report_id})">${res.data[i].report_reference_number}</a>`;
                          }
                         
                        }


                        // $("#past_medical_history").html(attach);
                        $("#gender").val(res.data[0].gender);
                        $("#dob").val(res.data[0].patient_date_of_birth);
                        $("#blood_group").val(res.data[0].blood_group);
                        $("#allergies").val(res.data[0].allergies);
                        $("#company_name").val(res.data[0].company_name);
                        $("#occupation").val(res.data[0].occupation);
                        var age = calculateAge(new Date(res.data[0].patient_date_of_birth));
                        $('.age').text(age);
                        $("#past_medical_history").val(res.data[0].past_medical_history);
                        $("#past_surgical_history").val(res.data[0].past_surgical_history);
                        $("#past_drug_history").val(res.data[0].past_drug_history);
                        

                },
                complete: function() {
                         //  me.data('requestRunning', false);
                }

    }); // submit ajax

}


$(document).ready(function() {

   
    get_Doctors();

    get_Country('cp_')
    get_Company('cp_')
    get_Patient_Group('cp_');

    init_select2_lab('product_id_fk');
    init_select2_rad('rad_product_id_fk');


    $("#print_btn").on('click', function(e){
        e.preventDefault();
        print('view_table');
    });

   
    $("#add_table_serv").on('click','.clone_btn', function(e){
        e.preventDefault()
        var $tr     = $(this).closest('.clone_row');
        var typ     = $tr.find('#serv_test_type\\[\\]').val()

        var $clone  = $tr.clone();
        $clone.find(':text').val('');
        $clone.find(':input').val('');
        $clone.find("span.select2").remove();
        $clone.find('#serv_test_type\\[\\]').val(typ);
        
        $tr.after($clone);
        init_select2_serv('serv_product_id_fk');
        $clone.find('#serv_date\\[\\]').daterangepicker({ 
            showDropdowns: true,
            timePicker: true,
            singleDatePicker: true,
            startDate: moment(),
            applyClass: 'bg-slate-600',
            locale: {
                format: 'YYYY-MM-DD H:mm'
            }
        });

    });



    $("body").on('change','#view_cond', function(e){
        e.preventDefault();
        $(".datatable-column-search-inputs").DataTable().ajax.reload(null, false);
        
    })

    // $("#patient_id_fk").on('change', function(e){
    //     e.preventDefault();
    //     var id = $(this).val();
    //     get_patient_report(id)        
    // })

    $('body').on('select2:select','#patient_id_fk', function (e) {
        var data            = e.params.data.data;
        var company_id_fk   = e.params.data.data.company_id_fk ;
        var insurance       = e.params.data.data.insurance;
        var patient_id      = e.params.data.data.patient_id ;
        get_patient_report(patient_id)

        

        if (insurance == 'Share Holder' || insurance == 'Insurance covered' || insurance == 'Pre Employment') {
            $price_profile = 'cost price';
        }else if (company_id_fk > 0 ){
            $price_profile = 'company price';
            if (company_id_fk==7) { // for OPHKL Company
                $price_profile = 'ophkl price';
            }
        }else{
            $price_profile = 'alliance price';
        }

        console.log($price_profile)
       
        console.log(data);
    });

    $('body').on('select2:select','#edit_patient_id_fk', function (e) {
        var data            = e.params.data.data;
        var company_id_fk   = e.params.data.data.company_id_fk ;
        var insurance       = e.params.data.data.insurance;
        var patient_id      = e.params.data.data.patient_id ;
        get_patient_report(patient_id)

        if (insurance == 'Share Holder' || insurance == 'Insurance covered' || insurance == 'Pre Employment') {
            $price_profile = 'cost price';
        }else if (company_id_fk > 0 ){
            $price_profile = 'company price';
            if (company_id_fk==7) { // for OPHKL Company
                $price_profile = 'ophkl price';
            }
        }else{
            $price_profile = 'alliance price';
        }

        console.log($price_profile)
       
        console.log(data);
    });

    $('body').on('select2:select','#product_id_fk\\[\\]', function (e) {
        var data = e.params.data.data;
        var cost = e.params.data.data.product_cost;
        var sell = e.params.data.data.sell_price;
        var comp = e.params.data.data.company_price;
        var ophk = e.params.data.data.ophkl_price;
        var grop = e.params.data.data.product_group_id_fk;
        var pid  = e.params.data.data.product_id;
        var $tr     = $(this).closest('.clone_row');
        
        // $tr.find('#sell\\[\\]').val(sell)
        $tr.find('#cost\\[\\]').val(cost)

        if ($price_profile =='' || $("#patient_id_fk").val() ==null) {
            alert(i18n.t('Please Select the Patient First then you can add investagation and consultation'))
            $tr.find('#product_id_fk\\[\\]').val('').trigger('change');
            return null;
        }

        if($price_profile =='cost price'){
             $tr.find('#sell\\[\\]').val(cost)
        }else if($price_profile =='company price'){
             $tr.find('#sell\\[\\]').val(comp)
        }else if($price_profile =='ophkl price'){
             $tr.find('#sell\\[\\]').val(ophk)
        }else{
            $tr.find('#sell\\[\\]').val(sell)
        }

        if (grop>0) {

            $.ajax({
                    url : 'models/crul_product.php',
                    type : 'POST',
                    data : {type:'get_group_of_product',
                            q:grop,
                            id:pid},
                    dataType : 'json',
                    success : function(res) {

                        if (res.length>0) {

                            var typ     = $tr.find('#test_type\\[\\]').val()

                          
                            for(var i=0 ; i < res.length ;i++){
                                

                                var $clone  = $tr.clone();
                                $clone.find(':text').val('');
                                $clone.find(':input').val('');
                                $clone.find("span.select2").remove();
                                $clone.find('#test_type\\[\\]').val(typ);
                                // $clone.find('#sell\\[\\]').val(res[i].sell_price);
                                $clone.find('#cost\\[\\]').val(res[i].product_cost);

                                if ($price_profile =='' || $("#patient_id_fk").val() ==null) {
                                    alert(i18n.t('Please Select the Patient First then you can add investagation and consultation'))
                                    $clone.find('#product_id_fk\\[\\]').val('').trigger('change');
                                    return null;
                                }

                                if($price_profile =='cost price'){
                                    $clone.find('#sell\\[\\]').val(res[i].product_cost);
                                }else if($price_profile =='company price'){
                                    $clone.find('#sell\\[\\]').val(res[i].company_price);
                                }else if($price_profile =='ophkl price'){
                                    $clone.find('#sell\\[\\]').val(res[i].ophkl_price);
                                }else{
                                    $clone.find('#sell\\[\\]').val(res[i].sell_price);
                                }
                                
                                $tr.after($clone);
                                init_select2_lab('product_id_fk');

                                var data = {
                                    id: res[i].product_id,
                                    text: res[i].product_name
                                };

                                if ($clone.find('#product_id_fk\\[\\]').find("option[value='" + data.id + "']").length) {
                                    $clone.find('#product_id_fk\\[\\]').val(data.id).trigger('change');
                                } else { 
                                    var newOption = new Option(data.text, data.id, true, true);
                                    $clone.find('#product_id_fk\\[\\]').append(newOption).trigger('change');
                                } 
                             
                            }
                        }

                    },
                    complete: function() {
                    }

            }); // submit ajax

        }
        console.log(data);
    });

    $('body').on('select2:select','#rad_product_id_fk\\[\\]', function (e) {
        var data = e.params.data.data;
        var cost = e.params.data.data.product_cost;
        var sell = e.params.data.data.sell_price;
        var comp = e.params.data.data.company_price;
        var ophk = e.params.data.data.ophkl_price;
        var grop = e.params.data.data.product_group_id_fk;
        var pid  = e.params.data.data.product_id;
        var $tr     = $(this).closest('.clone_row');
        
        // $tr.find('#rad_sell\\[\\]').val(sell)
        $tr.find('#rad_cost\\[\\]').val(cost)

        if ($price_profile =='' || $("#patient_id_fk").val() ==null) {
            alert(i18n.t('Please Select the Patient First then you can add investagation and consultation'))
            $tr.find('#rad_product_id_fk\\[\\]').val('').trigger('change');
            return null;
        }

        if($price_profile =='cost price'){
             $tr.find('#rad_sell\\[\\]').val(cost)
        }else if($price_profile =='company price'){
             $tr.find('#rad_sell\\[\\]').val(comp)
        }else if($price_profile =='ophkl price'){
             $tr.find('#rad_sell\\[\\]').val(ophk)
        }else{
            $tr.find('#rad_sell\\[\\]').val(sell)
        }

        if (grop>0) {

            $.ajax({
                    url : 'models/crul_product.php',
                    type : 'POST',
                    data : {type:'get_group_of_product',
                            q:grop,
                            id:pid},
                    dataType : 'json',
                    success : function(res) {

                        if (res.length>0) {

                            var typ     = $tr.find('#rad_test_type\\[\\]').val()

                          
                            for(var i=0 ; i < res.length ;i++){
                                

                                var $clone  = $tr.clone();
                                $clone.find(':text').val('');
                                $clone.find(':input').val('');
                                $clone.find("span.select2").remove();
                                $clone.find('#rad_test_type\\[\\]').val(typ);
                                // $clone.find('#rad_sell\\[\\]').val(res[i].sell_price);
                                $clone.find('#rad_cost\\[\\]').val(res[i].product_cost);

                                if ($price_profile =='' || $("#patient_id_fk").val() ==null) {
                                    alert(i18n.t('Please Select the Patient First then you can add investagation and consultation'))
                                    $clone.find('#rad_product_id_fk\\[\\]').val('').trigger('change');
                                    return null;
                                }

                                if($price_profile =='cost price'){
                                    $clone.find('#rad_sell\\[\\]').val(res[i].product_cost);
                                }else if($price_profile =='company price'){
                                    $clone.find('#rad_sell\\[\\]').val(res[i].company_price);

                                }else if($price_profile =='ophkl price'){
                                    $clone.find('#rad_sell\\[\\]').val(res[i].ophkl_price);

                                }else{
                                    $clone.find('#rad_sell\\[\\]').val(res[i].sell_price);
                                }
                                
                                $tr.after($clone);
                                init_select2_rad('rad_product_id_fk');

                                var data = {
                                    id: res[i].product_id,
                                    text: res[i].product_name
                                };

                                if ($clone.find('#rad_product_id_fk\\[\\]').find("option[value='" + data.id + "']").length) {
                                    $clone.find('#rad_product_id_fk\\[\\]').val(data.id).trigger('change');
                                } else { 
                                    var newOption = new Option(data.text, data.id, true, true);
                                    $clone.find('#rad_product_id_fk\\[\\]').append(newOption).trigger('change');
                                } 
                             
                            }
                        }

                    },
                    complete: function() {
                    }

            }); // submit ajax

        }
        console.log(data);
    });

    $('body').on('select2:select','#edit_product_id_fk\\[\\]', function (e) {
        var data = e.params.data.data;
        var cost = e.params.data.data.product_cost;
        var sell = e.params.data.data.sell_price;
        var comp = e.params.data.data.company_price;
        var ophk = e.params.data.data.ophkl_price;
        var grop = e.params.data.data.product_group_id_fk;
        var pid  = e.params.data.data.product_id;
        var $tr     = $(this).closest('.clone_row');
        
        // $tr.find('#edit_sell\\[\\]').val(sell)
        $tr.find('#edit_cost\\[\\]').val(cost)

        if ($price_profile =='' || $("#edit_patient_id_fk").val() ==null) {
            alert(i18n.t('Please Select the Patient First then you can add investagation and consultation'))
            $tr.find('#edit_product_id_fk\\[\\]').val('').trigger('change');
            return null;
        }

        if($price_profile =='cost price'){
             $tr.find('#edit_sell\\[\\]').val(cost)
        }else if($price_profile =='company price'){
             $tr.find('#edit_sell\\[\\]').val(comp)
        }else if($price_profile =='ophkl price'){
             $tr.find('#edit_sell\\[\\]').val(ophk)
        }else{
            $tr.find('#edit_sell\\[\\]').val(sell)
        }


        if (grop>0) {

            $.ajax({
                    url : 'models/crul_product.php',
                    type : 'POST',
                    data : {type:'get_group_of_product',
                            q:grop,
                            id:pid},
                    dataType : 'json',
                    success : function(res) {

                        if (res.length>0) {

                            var typ     = $tr.find('#edit_test_type\\[\\]').val()
                            var lbid    = $tr.find('#edit_lab_test_id\\[\\]').val()
                            var lbdid   = $tr.find('#edit_lab_test_detail_id\\[\\]').val()
                           

                          
                            for(var i=0 ; i < res.length ;i++){
                                

                                var $clone  = $tr.clone();
                                $clone.find(':text').val('');
                                $clone.find(':input').val('');
                                $clone.find("span.select2").remove();
                                $clone.find('#edit_test_type\\[\\]').val(typ);
                                // $clone.find('#edit_sell\\[\\]').val(res[i].sell_price);
                                $clone.find('#edit_cost\\[\\]').val(res[i].product_cost);
                                $clone.find('#edit_lab_test_id\\[\\]').val(res[i].lbid);
                                $clone.find('#edit_lab_test_detail_id\\[\\]').val(res[i].lbdid);

                                if ($price_profile =='' || $("#edit_patient_id_fk").val() ==null) {
                                    alert(i18n.t('Please Select the Patient First then you can add investagation and consultation'))
                                    $clone.find('#edit_product_id_fk\\[\\]').val('').trigger('change');
                                    return null;
                                }

                                if($price_profile =='cost price'){
                                    $clone.find('#edit_sell\\[\\]').val(res[i].product_cost);
                                }else if($price_profile =='company price'){
                                    $clone.find('#edit_sell\\[\\]').val(res[i].company_price);

                                }else if($price_profile =='ophkl price'){
                                    $clone.find('#edit_sell\\[\\]').val(res[i].ophkl_price);

                                }else{
                                    $clone.find('#edit_sell\\[\\]').val(res[i].sell_price);
                                }
                                
                                $tr.after($clone);
                                init_select2_lab('edit_product_id_fk');

                                var data = {
                                    id: res[i].product_id,
                                    text: res[i].product_name
                                };

                                if ($clone.find('#edit_product_id_fk\\[\\]').find("option[value='" + data.id + "']").length) {
                                    $clone.find('#edit_product_id_fk\\[\\]').val(data.id).trigger('change');
                                } else { 
                                    var newOption = new Option(data.text, data.id, true, true);
                                    $clone.find('#edit_product_id_fk\\[\\]').append(newOption).trigger('change');
                                } 
                             
                            }
                        }

                    },
                    complete: function() {
                    }

            }); // submit ajax

        }
       
        console.log(data);
    });

    $('body').on('select2:select','#edit_rad_product_id_fk\\[\\]', function (e) {
        var data = e.params.data.data;
        var cost = e.params.data.data.product_cost;
        var sell = e.params.data.data.sell_price;
        var comp = e.params.data.data.company_price;
        var ophk = e.params.data.data.ophkl_price;
        var grop = e.params.data.data.product_group_id_fk;
        var pid  = e.params.data.data.product_id;
        var $tr     = $(this).closest('.clone_row');
        
        // $tr.find('#edit_rad_sell\\[\\]').val(sell)
        $tr.find('#edit_rad_cost\\[\\]').val(cost)

        if ($price_profile =='' || $("#edit_patient_id_fk").val() ==null) {
            alert(i18n.t('Please Select the Patient First then you can add investagation and consultation'))
            $tr.find('#edit_rad_product_id_fk\\[\\]').val('').trigger('change');
            return null;
        }

        if($price_profile =='cost price'){
             $tr.find('#edit_rad_sell\\[\\]').val(cost)
        }else if($price_profile =='company price'){
             $tr.find('#edit_rad_sell\\[\\]').val(comp)
        }else if($price_profile =='ophkl price'){
             $tr.find('#edit_rad_sell\\[\\]').val(ophk)
        }else{
            $tr.find('#edit_rad_sell\\[\\]').val(sell)
        }

        if (grop>0) {

            $.ajax({
                    url : 'models/crul_product.php',
                    type : 'POST',
                    data : {type:'get_group_of_product',
                            q:grop,
                            id:pid},
                    dataType : 'json',
                    success : function(res) {

                        if (res.length>0) {

                            var typ     = $tr.find('#edit_rad_test_type\\[\\]').val()

                          
                            for(var i=0 ; i < res.length ;i++){
                                

                                var $clone  = $tr.clone();
                                $clone.find(':text').val('');
                                $clone.find(':input').val('');
                                $clone.find("span.select2").remove();
                                $clone.find('#edit_rad_test_type\\[\\]').val(typ);
                                // $clone.find('#edit_rad_sell\\[\\]').val(res[i].sell_price);
                                $clone.find('#edit_rad_cost\\[\\]').val(res[i].product_cost);

                                if ($price_profile =='' || $("#edit_patient_id_fk").val() ==null) {
                                    alert(i18n.t('Please Select the Patient First then you can add investagation and consultation'))
                                    $clone.find('#edit_rad_product_id_fk\\[\\]').val('').trigger('change');
                                    return null;
                                }

                                if($price_profile =='cost price'){
                                    $clone.find('#edit_rad_sell\\[\\]').val(res[i].product_cost);
                                }else if($price_profile =='company price'){
                                    $clone.find('#edit_rad_sell\\[\\]').val(res[i].company_price);

                                }else if($price_profile =='ophkl price'){
                                    $clone.find('#edit_rad_sell\\[\\]').val(res[i].ophkl_price);

                                }else{
                                    $clone.find('#edit_rad_sell\\[\\]').val(res[i].sell_price);
                                }
                                
                                $tr.after($clone);
                                init_select2_rad('edit_rad_product_id_fk');

                                var data = {
                                    id: res[i].product_id,
                                    text: res[i].product_name
                                };

                                if ($clone.find('#edit_rad_product_id_fk\\[\\]').find("option[value='" + data.id + "']").length) {
                                    $clone.find('#edit_rad_product_id_fk\\[\\]').val(data.id).trigger('change');
                                } else { 
                                    var newOption = new Option(data.text, data.id, true, true);
                                    $clone.find('#edit_rad_product_id_fk\\[\\]').append(newOption).trigger('change');
                                } 
                             
                            }
                        }

                    },
                    complete: function() {
                    }

            }); // submit ajax

        }
        console.log(data);
    });

    $("#add_table_radiology").on('click','.clone_btn', function(e){
        e.preventDefault()
        var $tr     = $(this).closest('.clone_row');
        var typ     = $tr.find('#rad_test_type\\[\\]').val()

        var $clone  = $tr.clone();
        $clone.find(':text').val('');
        $clone.find(':input').val('');
        $clone.find("span.select2").remove();
        $clone.find('#rad_test_type\\[\\]').val(typ);
        
        $tr.after($clone);
        init_select2_rad('rad_product_id_fk');

    });

    $("#edit_table_radiology").on('click','.clone_btn', function(e){
        e.preventDefault()
        var $tr     = $(this).closest('.clone_row');
        var typ     = $tr.find('#edit_rad_test_type\\[\\]').val()
        var ivid    = $tr.find('#edit_radiology_test_id\\[\\]').val()

        var $clone  = $tr.clone();
        $clone.find(':text').val('');
        $clone.find(':input').val('');
        $clone.find("span.select2").remove();
        $clone.find('#edit_rad_test_type\\[\\]').val(typ);
        $clone.find('#edit_radiology_test_id\\[\\]').val(ivid);
        $clone.find("span.remove_tr").removeClass('hide-minus-btn');
        $clone.find("#edit_rad_product_id_fk\\[\\]").prop('disabled',false);
        $clone.find("input.temp-item").remove();
        
        $tr.after($clone);
        init_select2_rad('edit_rad_product_id_fk');

    });

    $("#add_table_radiology").on('click','.remove_tr', function(e){
        e.preventDefault()
        $(this).closest('tr').remove();
    });

    $("#edit_table_radiology").on('click','.remove_tr', function(e){
        e.preventDefault()
        $(this).closest('tr').remove();
    });


    $("#add_table_lab").on('click','.clone_btn', function(e){
        e.preventDefault()
        var $tr     = $(this).closest('.clone_row');
        var typ     = $tr.find('#test_type\\[\\]').val()

        var $clone  = $tr.clone();
        $clone.find(':text').val('');
        $clone.find(':input').val('');
        $clone.find("span.select2").remove();
        $clone.find('#test_type\\[\\]').val(typ);
        
        $tr.after($clone);
        init_select2_lab('product_id_fk');

    });

    $("#edit_table_lab").on('click','.clone_btn', function(e){
        e.preventDefault()
        var $tr     = $(this).closest('.clone_row');
        var typ     = $tr.find('#edit_test_type\\[\\]').val()
        var ivid    = $tr.find('#edit_lab_test_id\\[\\]').val()

        var $clone  = $tr.clone();
        $clone.find(':text').val('');
        $clone.find(':input').val('');
        $clone.find("span.select2").remove();
        $clone.find('#edit_test_type\\[\\]').val(typ);
        $clone.find('#edit_lab_test_id\\[\\]').val(ivid);
        $clone.find("span.remove_tr").removeClass('hide-minus-btn');
        $clone.find("#edit_product_id_fk\\[\\]").prop('disabled',false);
        $clone.find("input.temp-item").remove();
        
        $tr.after($clone);
        init_select2_lab('edit_product_id_fk');

    });

    $("#add_table_lab").on('click','.remove_tr', function(e){
        e.preventDefault()
        $(this).closest('tr').remove();
    });

    $("#edit_table_lab").on('click','.remove_tr', function(e){
        e.preventDefault()
        $(this).closest('tr').remove();
    });

  
    $("#submit_add_btn").on('click', function(e){
        e.preventDefault();

        // $(".li-tabs").removeClass('active');
        $("#active-tab").addClass('active');
        $("#bordered-justified-tab1").addClass('active');
        $('#submit_add_btn_triger').trigger('click');

    });

    $("#submit_edit_btn").on('click', function(e){
        e.preventDefault();
        // $(".edit-li-tabs").removeClass('active');
        $("#edit_active-tab").addClass('active');
        $("#edit-bordered-justified-tab1").addClass('active');
        $('#submit_edit_btn_triger').trigger('click');
    });

    $("#submit_status_btn").on('click', function(e){
        e.preventDefault();

        // $(".pass-li-tabs").removeClass('active');
        $("#status_active-tab").addClass('active');
        $("#status-bordered-justified-tab1").addClass('active');
        $('#submit_status_btn_triger').trigger('click');
    });

    

    $('#add_form').submit(function(event) {
      event.preventDefault();

      

      var fd=new FormData(this);
      
      fd.append("type",'create');

      $("#submit_add_btn").attr('disabled',true);
      $.ajax({
          url: "models/crul_breast_clinic.php",
          type:"POST",
          dataType: "JSON",
          data: fd,
          processData: false,
          contentType: false
      
      })
      .done(function(res) {
         
          if(res.is_success == true){

            $("#add_form")[0].reset();
            $('#tree-container').html('');

            noty({
                  width: 200,
                  text: i18n.t(res.data),
                  type: 'success',
                  dismissQueue: true,
                  timeout: 2000,
                  layout: 'topRight',
                  callback: {
                              onShow: function() {
                                $(".datatable-column-search-inputs").DataTable().ajax.reload(null, false);

                              },
                              afterShow: function() {
                               // show_report(res.id,'Print');
                              },
                              onClose: function() {

                                location.reload();
                              },
                              afterClose: function() {},
                              onCloseClick: function() {},
                            },
            });

         
          }else{
              swal({
                  title: i18n.t("Error"),
                  text: i18n.t(res.data),
                  confirmButtonColor: "#66BB6A",
                  type: "warning"
              });
          }

          $("#submit_add_btn").attr('disabled',false);
      })
      .fail(function(err) {
          $("#submit_add_btn").attr('disabled',false);

           swal({
              title: i18n.t("Error"),
              text: (err),
              confirmButtonColor: "#66BB6A",
              type: "error"
          });
          $("#submit_add_btn").attr('disabled',false);
      })
      .always(function() {
          console.log("complete");
          $("#submit_add_btn").attr('disabled',false);

      });
      

    });


    $('#edit_form').submit(function(event) {
          event.preventDefault();
          
          $("#submit_edit_btn").attr('disabled',true);

          var formData = new FormData(this);

          formData.append("type", 'update');     

          $.ajax({
                  url: "models/crul_breast_clinic.php",
                  type:"POST",
                  dataType : "JSON",
                  data: formData,
                  processData: false,
                  contentType: false
                })
                .done(function(res) {

                    $("#submit_edit_btn").attr('disabled',false);

             
                    if(res.is_success == true){

                      $('#edit_form_cont').modal('toggle');
                      $("#edit_form")[0].reset();

                      noty({
                            width: 200,
                            text: i18n.t(res.data),
                            type: 'success',
                            dismissQueue: true,
                            timeout: 2000,
                            layout: 'topRight',
                            callback: {
                                        onShow: function() {

                                        },
                                        afterShow: function() {
                                         // show_report(res.id,'Print');
                                          $(".datatable-column-search-inputs").DataTable().ajax.reload(null, false);

                                        },
                                        onClose: function() {

                                          // location.reload();
                                        },
                                        afterClose: function() {},
                                        onCloseClick: function() {},
                                      },
                      });

                   
                    }else{
                        swal({
                            title: i18n.t("Error"),
                            text: i18n.t(res.data),
                            confirmButtonColor: "#66BB6A",
                            type: "warning"
                        });
                    }

                })
                .fail(function(err) {
                    $("#submit_edit_btn").attr('disabled',false);

                    swal({
                        title: i18n.t("Error"),
                        text: (err),
                        confirmButtonColor: "#66BB6A",
                        type: "error"
                    });
                })
                .always(function() {
                    console.log("complete");
                    $("#submit_edit_btn").attr('disabled',false);

                });

                 
        

    });

    $('#status_form').submit(function(event) {
          event.preventDefault();
          
          $("#submit_status_btn").attr('disabled',true);

          var formData = new FormData(this);

          formData.append("type", 'set_status');     

          $.ajax({
                  url: "models/crul_reception.php",
                  type:"POST",
                  dataType : "JSON",
                  data: formData,
                  processData: false,
                  contentType: false
                })
                .done(function(res) {

                    $("#submit_status_btn").attr('disabled',false);

             
                    if(res.is_success == true){

                      $('#status_form_cont').modal('toggle');
                      $("#status_form")[0].reset();

                      noty({
                            width: 200,
                            text: i18n.t(res.data),
                            type: 'success',
                            dismissQueue: true,
                            timeout: 2000,
                            layout: 'topRight',
                            callback: {
                                        onShow: function() {

                                        },
                                        afterShow: function() {
                                         // show_report(res.id,'Print');
                                          $(".datatable-column-search-inputs").DataTable().ajax.reload(null, false);

                                        },
                                        onClose: function() {

                                          // location.reload();
                                        },
                                        afterClose: function() {},
                                        onCloseClick: function() {},
                                      },
                      });

                   
                    }else{
                        swal({
                            title: i18n.t("Error"),
                            text: i18n.t(res.data),
                            confirmButtonColor: "#66BB6A",
                            type: "warning"
                        });
                    }

                })
                .fail(function(err) {
                    $("#submit_status_btn").attr('disabled',false);

                    swal({
                        title: i18n.t("Error"),
                        text: (err),
                        confirmButtonColor: "#66BB6A",
                        type: "error"
                    });
                })
                .always(function() {
                    console.log("complete");
                    $("#submit_status_btn").attr('disabled',false);

                });

                 
        

    });
   


});
function calculateAge(dateOfBirth) {
    const today = new Date();
    const birthDate = new Date(dateOfBirth);

    let years = today.getFullYear() - birthDate.getFullYear();
    let months = today.getMonth() - birthDate.getMonth();
    let days = today.getDate() - birthDate.getDate();

    if (days < 0) {
        months--;
        days += new Date(today.getFullYear(), today.getMonth(), 0).getDate();
    }

    if (months < 0) {
        years--;
        months += 12;
    }

    let ageString = '';
    if (years > 1) {
        ageString += `${years} years`;
    } else {
        if (years === 1) {
            ageString += `${years} year`;
        }
        if (months > 0) {
            if (ageString) ageString += ', ';
            ageString += `${months} months`;
        }
        if (days > 0) {
            if (ageString) ageString += ', ';
            ageString += `${days} days`;
        }
    }

    return ageString;
}

$(function() {

    $('[name="phone_number"]').formatter({
        pattern: '+{{999}} {{999}} {{999}} {{9999}}'
    });

    $('select[name$="patient_id_fk"]').select2({
        minimumResultsForSearch: -1,
        ajax: {
            url: "models/crul_patient.php",
            dataType: 'json',
            type: 'POST',
            quietMillis: 100,
            data: function (data, page) {
                return {
                    type: 'search',
                    dataType:'',
                    condition: '',
                    q:data.term,
                    page_limit: 8,
                    page: 10
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if (data.length > 0) {
                    var results = [];
                    $.each(data, function (index, item) {
                        //console.log(item)
                        results.push({
                            id: item.patient_id,
                            text: item.patient_full_name,
                            data: item
                        });
                    });
                    return {
                        results:results,
                        pagination: {
                            more: (params.page * 30) < data.length
                          }
                    };
                }
            }
        },
        escapeMarkup: function (markup) {
            return markup; 
        },
        templateResult: function(res){
            if (res.loading) {
                return res.text;
            }
            if(res.data.patient_id==0){
                return `
                    <div class="media">
                        <div class="media-left media-middle">
                            <a href="#" class="btn bg-pink-400 btn-rounded btn-icon btn-xlg">
                                <span class="">${res.data.patient_id}</span>
                            </a>
                        </div>
                        <div class="media-body">
                            <div class="media-heading">
                                <a href="#" class="letter-icon-title">${res.data.patient_full_name}</a>
                            </div>
                        </div>
                    </div>
                `;
            }else{
                return `
                    <div class="media">
                        <div class="media-left media-middle">
                            <a href="#" class="btn bg-pink-400 btn-rounded btn-icon btn-xlg">
                                <span class="">${res.data.patient_id}</span>
                            </a>
                        </div>
                        <div class="media-body">
                            <p>${res.data.patient_full_name}</p>
                        </div>
                    </div>
                `;
            }
        },
        templateSelection: function  (res) {
            console.error(res)
            return res.q || res.text;
        },
        minimumInputLength: 2,
        placeholder: "Search Name, Mobile, Card ID"
    });

    // Bootstrap Select

    $.fn.selectpicker.defaults = {
        iconBase: '',
        tickIcon: 'icon-checkmark3'
    }

    // Basic select
    $('.bootstrap-select').selectpicker();

    // Select all method
    $('#select-all-values').on('click', function() {
        $('.bootstrap-select').selectpicker('selectAll');
    });


    // Deselect all method
    $('#deselect-all-values').on('click', function() {
        $('.bootstrap-select').selectpicker('deselectAll');
    });


    $('.tokenfield-primary').on('tokenfield:initialize', function (e) {
        $(this).parent().find('.token').addClass('bg-primary')
    });

    // Initialize plugin
    $('.tokenfield-primary').tokenfield();

    // Add class when token is created
    $('.tokenfield-primary').on('tokenfield:createdtoken', function (e) {
        $(e.relatedTarget).addClass('bg-primary')
    });

    // End Bootstrap Select

    $('.daterange-single').daterangepicker({ 
        showDropdowns: true,
        timePicker: true,
        singleDatePicker: true,
        startDate: moment(),
        applyClass: 'bg-slate-600',
        locale: {
            format: 'YYYY-MM-DD H:mm'
        }
    });

    // Numeric date
    $("#anytime-month-numeric").AnyTime_picker({
        format: "%z-%m-%d"
        // format: "%z-%m-%d %H:%i"
    });

    
    var t1 = i18n.t('Search')==''?'Search':i18n.t('Search');
    var t2 = i18n.t('Search For')==''?'Search For':i18n.t('Search For');
    var t3 = i18n.t('Show')==''?'Show':i18n.t('Show');
   // Setting datatable defaults
    $.extend( $.fn.dataTable.defaults, {
        autoWidth: false,
        columnDefs: [{ 
            orderable: false,
            width: '100px',
            targets: [ 4 ]
        }],
        dom: '<"datatable-header"fBl><"datatable-scroll"t><"datatable-footer"ip>',
        language: {
            search: '<span>'+ t1 +':</span> _INPUT_',
            searchPlaceholder: t2 +'...',
            lengthMenu: '<span>'+ t3 +':</span> _MENU_',
            paginate: { 'first': 'First', 'last': 'Last', 'next': '&'+Left_Arraw+'arr;', 'previous': '&'+Right_Arraw+'arr;' }
        },
        drawCallback: function () {
            $(this).find('tbody tr').slice(-3).find('.dropdown, .btn-group').addClass('dropup');
        },
        preDrawCallback: function() {
            $(this).find('tbody tr').slice(-3).find('.dropdown, .btn-group').removeClass('dropup');
        }
    });

    

    // Individual column searching with text inputs
    $('.datatable-column-search-inputs tfoot td').not(':last-child').each(function () {
        var title = $('.datatable-column-search-inputs thead th').eq($(this).index()).text();
        $(this).html('<input type="text" class="form-control input-sm" placeholder="'+i18n.t('بحث عن')+' '+title+'" />');
    });
    
    

   
    table = $('.datatable-column-search-inputs').DataTable({
        buttons: {            
            buttons: [
                {
                    extend: 'copyHtml5',
                    className: 'btn btn-default',
                    exportOptions: {
                        columns: [ 0, ':visible' ]
                    }
                },
                {
                    extend: 'excelHtml5',
                    className: 'btn btn-default',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'pdfHtml5',
                    className: 'btn btn-default',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'print',
                    className: 'btn btn-default',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'colvis',
                    text: '<i class="icon-three-bars"></i> <span class="caret"></span>',
                    className: 'btn bg-blue btn-icon'
                }
                
            ]
        },
        lengthMenu: [
            [  10, 25, 50, 100, -1 ],
            [  '10', '25', '50', '100', 'All' ]
        ],
        "processing": true,
        "serverSide": true,
        "ajax": {
        "url" : "models/crul_breast_clinic.php",
        "data": function(d){
            d.type = "load";
            var view_cond = $("#view_cond").val();

            if (view_cond ==null) {
                d.view_type = 'today';
            }else{
                d.view_type = view_cond;
            }
        }
        },
        drawCallback: function() {
                  $('[data-popup=tooltip]').tooltip();
                  $('[data-popup=popover-custom]').popover({
                    template: '<div class="popover  border-teal-400"><div class="arrow"></div><h3 class="popover-title bg-teal-400"></h3><div class="popover-content"></div></div>'
                  });

                 

            },
        "columnDefs": [
          {
                "targets": 10,
                "data": null,
                "render": function (data,type,row) {

                    var btns = ``;

                    if(IS_VIEW==0){

                        if (check_permission(192,row[11])) {
                          btns+= `<li class='text-primary-300'>
                                      <a  class='text-primary-300' onclick="edit_items(${row[0]})" data-popup='tooltip' data-original-title='' style="font-size:16px;">
                                          <i class='icon-pencil7 icon-2x'></i> ${i18n.t('Edit')}
                                      </a>
                                  </li>`;
                        }

                        if (check_permission(194)) {
                          btns+= `<li class='text-info-300'>
                                      <a  class='text-info-300' onclick="view(${row[0]})" data-popup='tooltip' data-original-title='' style="font-size:16px;">
                                          <i class='icon-printer4 icon-2x'></i> ${i18n.t('Display Checkup')}
                                      </a>
                                  </li>`;
                        }

                        
                        

                        if (check_permission(193,row[11])) {
                          btns+= `<li class='text-danger-300'>
                                      <a  class='text-danger-300' onclick="delete_items(${row[0]})" data-popup='tooltip' data-original-title='' style="font-size:16px;">
                                          <i class='icon-trash icon-2x'></i> ${i18n.t('Delete')}
                                      </a>
                                  </li>`;
                        }

                        

                        if (check_permission(195)) {
                          btns+= `<li class='text-info-300'>
                                      <a  class='text-info-300' onclick="get_log(${row[0]},'breast_clinic')" data-popup='tooltip' data-original-title='' style="font-size:16px;">
                                          <i class='icon-file-text2 icon-2x'></i> ${i18n.t('Record Log')}
                                      </a>
                                  </li>`;
                        }

                        

                        

                        return  `<ul class='icons-list '>
                                  
                                    

                                     
                                    <li class="dropdown">
                                      <a  class="dropdown-toggle" data-toggle="dropdown" >
                                        <i class="icon-menu9 icon-2x"></i>
                                      </a>

                                      <ul class="dropdown-menu dropdown-menu-right" style="min-width:250px;">

                                        ${btns}                                             

                                      </ul>
                                    </li>
                                  </ul>`;
                    }else{
                      return '';
                    }
                  

                }
          },

          {
             "render": function(data, type, row){
                    
                return `<a  class='text-info-300' onclick="view(${row[0]})" data-popup='tooltip' data-original-title='' style="font-size:16px;">
                                          ${data}
                        </a>`
             },
             
             "targets": 3
          },

          
         

           
        ],
        "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {


            if(   aData[4] == 0 ){
                $(nRow).children().each(function (index, td) {
                    $(this).addClass('warning-active');
                });
            }
        },
        "order": [[0,'desc']],
        "displayLength": 25,
 

        initComplete: function () {
         
        // $("div.datatable-header").append(`<a  style="margin-left:15px;" class="btn bg-info-400"  id="headerBtn" onclick="add_item()"> <i class="icon-file-pdf position-right"></i> Add Category </a>`);   
        if(IS_VIEW==0){
          
          if (check_permission(191)) {
          
            $("div.datatable-header").append(`<a data-toggle="collapse"
                                      style="margin:0 5px 0 5px;"
                                      data-target="#add-form-cont"
                                      href="javascript:;"
                                      aria-controls="add-form-cont"
                                      aria-expanded="false"
                                      class="btn btn-primary"
                                      id="add_Item_Btn">
                                        <i class="`+CURRENT_BTN_ICON+`"></i> `+i18n.t(CURRENT_BTN)+`
                                    </a>`); 
          } 

          // if (check_permission(21)) {
          
            $("div.datatable-header").append(`<div class="form-group has-feedback has-feedback-left col-lg-1 col-md-1 col-sm-1 col-xs-1">
                                                <select class="form-control" name="view_cond" id="view_cond" data-width="100%" data-live-search="true" style="padding-right: 5px !important; padding-left: 5px; !important">
                                                    <option value="all" data-i18n="page.reception.role">All</option>
                                                    <option value="today" selected data-i18n="page.reception.role">Today</option>
                                                    <option value="yesterday" data-i18n="page.reception.role">Yesterday</option>
                                                    <option value="tomorow" data-i18n="page.reception.role">Tomorow</option>
                                                    <option value="next_week" data-i18n="page.reception.role">Next Week</option>
                                                    <option value="last_week" data-i18n="page.reception.role">Last Week</option>
                                                    <option value="next_month" data-i18n="page.reception.role">Next Month</option>
                                                    <option value="last_month" data-i18n="page.reception.role">Last Month</option>
                                                </select>
                                              </div>`); 
          // } 

           
        }


            this.api().columns().every( function() {
                var column = this;
                

            });
        }
    });

    
    table.columns().every( function () {
        var that = this;
        $('input', this.footer()).on('keyup change', function () {
            that.search(this.value).draw();
        });
    });


    // Single row selection
    
    $('.datatable-column-search-inputs tbody').on('click', 'tr', function() {
        if ($(this).hasClass('success')) {
            $(this).removeClass('success');
        }
        else {
            table.$('tr.success').removeClass('success');
            $(this).addClass('success');
        }
    });


         // change filter to top
    $('.datatable-column-search-inputs tfoot tr').insertAfter($('.datatable-column-search-inputs thead tr'))


    $('.dataTables_length select').select2({
        minimumResultsForSearch: Infinity,
        width: 'auto'
    });

    // from cookies to save which column user hide or show 
    if (column_visible.length > 0) {
        table.columns(column_visible).visible(false);
    }

    $('#dob').on('change', function() {
        var dob = $(this).val();
        var age = calculateAge(new Date(dob));
        $('.age').text(age);
    });

    $('#edit_dob').on('change', function() {
        var dob = $(this).val();
        var age = calculateAge(new Date(dob));
        $('.editage').text(age);
    });

});



