/* ------------------------------------------------------------------------------
*
*  # Change language without page reload
*
*  Specific JS code additions for internationalization_switch_direct.html page
*
*  Version: 1.0
*  Latest update: Aug 1, 2015
*
* ---------------------------------------------------------------------------- */
let column_visible;

function setCookie(cname, cvalue, exdays) {
  const d = new Date();
  d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
  let expires = "expires="+d.toUTCString();
  document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
}

function getCookie(cname) {
  let name = cname + "=";
  let ca = document.cookie.split(';');
  for(let i = 0; i < ca.length; i++) {
    let c = ca[i];
    while (c.charAt(0) == ' ') {
      c = c.substring(1);
    }
    if (c.indexOf(name) == 0) {
      return c.substring(name.length, c.length);
    }
  }
  return "";
}

function checkCookie() {
  let user = getCookie("username");
  if (user != "") {
    alert("Welcome again " + user);
  } else {
    user = prompt("Please enter your name:", "");
    if (user != "" && user != null) {
      setCookie("username", user, 365);
    }
  }
}

$(document).ready(function() {
    let is_vis = getCookie('side-bar-visiblity');
    if (is_vis=='1') {
        $('.html_body').addClass('sidebar-xs');
    }else{
        $('.html_body').removeClass('sidebar-xs');
    }

    let theme           = getCookie('theme-mode');
    let company         = getCookie('company-mode');
    let theme_lang      = getCookie('language-mode');
    let rtl_css = '';
    // Change theme in dropdown
    if (theme_lang=='rtl') {
        rtl_css = '-rtl'
    }

    setPageDir(theme_lang,''); // set page direction


    let switch_theme    = $('.theme-switch');
    if (theme=='1') {
        
        setStyleSheet('bootcss','assets/css'+rtl_css+'/light/bootstrap.css')
        setStyleSheet('corecss','assets/css'+rtl_css+'/light/core.css')
        setStyleSheet('compcss','assets/css'+rtl_css+'/light/components.css')
        setStyleSheet('colorcss','assets/css'+rtl_css+'/light/colors.css')
        
        switch_theme.children('.dropdown-toggle').html(
            $('.light-css').html() + ' <i class="caret" />'
        );

        // Set active class
        switch_theme.find('li').removeClass('active');
        $('.light-css').parent().addClass('active');
    }else{
        // Change theme in dropdown

        setStyleSheet('bootcss','assets/css'+rtl_css+'/bootstrap.css')
        setStyleSheet('corecss','assets/css'+rtl_css+'/core.css')
        setStyleSheet('compcss','assets/css'+rtl_css+'/components.css')
        setStyleSheet('colorcss','assets/css'+rtl_css+'/colors.css')

        switch_theme.children('.dropdown-toggle').html(
            $('.dark-css').html() + ' <i class="caret" />'
        );

        // Set active class
        switch_theme.find('li').removeClass('active');
        $('.dark-css').parent().addClass('active');
    }

    let company_switch = $('.company-switch');

    if (company=='dfad') {
        
        company_switch.children('.dropdown-toggle').html(
            $('.dfad').html() + ' <i class="caret" />'
        );

        // Set active class
        company_switch.find('li').removeClass('active');
        $('.dfad').parent().addClass('active');

    }else if(company=='petro'){
        company_switch.children('.dropdown-toggle').html(
            $('.petro').html() + ' <i class="caret" />'
        );

        // Set active class
        company_switch.find('li').removeClass('active');
        $('.petro').parent().addClass('active');
    }else if(company=='afaq'){
        company_switch.children('.dropdown-toggle').html(
            $('.afaq').html() + ' <i class="caret" />'
        );

        // Set active class
        company_switch.find('li').removeClass('active');
        $('.afaq').parent().addClass('active');
    }else{
        

        company_switch.children('.dropdown-toggle').html(
            $('.healthcare').html() + ' <i class="caret" />'
        );

        // Set active class
        company_switch.find('li').removeClass('active');
        $('.healthcare').parent().addClass('active');
    }

    // columns Visiblity
    if (typeof PAGE_NAME !== 'undefined') {
        column_visible =  getCookie(PAGE_NAME);
    }
});


$(function() {

    $("body").on('click','a.buttons-columnVisibility',function(e){
            e.preventDefault();
            console.log($(this).context.innerText)
            var clm = $(this).context.innerText;
            var ln = table.columns().data().context[0].aoColumns.length
            var vsb_arr = [];
            var x=0;
            for (var i = 0; i <ln; i++) {

                var idx = table.columns().data().context[0].aoColumns[i].idx
                var tit = table.columns().data().context[0].aoColumns[i].sTitle
                var vsb = table.columns().data().context[0].aoColumns[i].bVisible
                
                if (vsb == false) {
                    vsb_arr[x] = idx;
                    x++;
                }
            }
            
            setCookie(PAGE_NAME, vsb_arr, 365);
            console.log(vsb_arr)
    })

    $('.sidebar-main-toggle').on('click', function(e){
        var is_vis = getCookie('side-bar-visiblity');
        is_vis = is_vis ^ 1;
        setCookie('side-bar-visiblity', is_vis, 365);
    })
  
    $('.sidebar-main').hover(

        function(){ // hover over

            var is_vis = getCookie('side-bar-visiblity');
            if (is_vis=='1') {
                $('.html_body').removeClass('sidebar-xs');
                $('.html_body').addClass('sidebar-fixed-expanded');
            }
        },
        function(){ // hover out
            var is_vis = getCookie('side-bar-visiblity');
            if (is_vis=='1') {
                $('.html_body').removeClass('sidebar-fixed-expanded');
                $('.html_body').addClass('sidebar-xs');
            }
            

        }
    );



    var switch_theme = $('.theme-switch');


    // Dark
    $('.dark-css').on('click', function () {

        let theme = 0;
        setCookie('theme-mode', theme, 365);

        let theme_lang      = getCookie('language-mode');
        let rtl_css = '';
        // Change theme in dropdown
        if (theme_lang=='rtl') {
            rtl_css = '-rtl'
        }

        setPageDir(theme_lang,''); // set page direction


        setStyleSheet('bootcss','assets/css'+rtl_css+'/bootstrap.css')
        setStyleSheet('corecss','assets/css'+rtl_css+'/core.css')
        setStyleSheet('compcss','assets/css'+rtl_css+'/components.css')
        setStyleSheet('colorcss','assets/css'+rtl_css+'/colors.css')

        // Change lang in dropdown
        switch_theme.children('.dropdown-toggle').html(
            $('.dark-css').html() + ' <i class="caret" />'
        );

        // Set active class
        switch_theme.find('li').removeClass('active');
        $('.dark-css').parent().addClass('active');
    });

    // Light
    $('.light-css').on('click', function () {

        let theme = 1;
        setCookie('theme-mode', theme, 365);

        let theme_lang      = getCookie('language-mode');
        let rtl_css = '';
        // Change theme in dropdown
        if (theme_lang=='rtl') {
            rtl_css = '-rtl'
        }

        setPageDir(theme_lang,''); // set page direction


        setStyleSheet('bootcss','assets/css'+rtl_css+'/light/bootstrap.css')
        setStyleSheet('corecss','assets/css'+rtl_css+'/light/core.css')
        setStyleSheet('compcss','assets/css'+rtl_css+'/light/components.css')
        setStyleSheet('colorcss','assets/css'+rtl_css+'/light/colors.css')

        // Change theme in dropdown
        switch_theme.children('.dropdown-toggle').html(
            $('.light-css').html() + ' <i class="caret" />'
        );

        // Set active class
        switch_theme.find('li').removeClass('active');
        $('.light-css').parent().addClass('active');
    });

    var company_switch = $('.company-switch');

    $('.healthcare').on('click', function () {

        let company = 'healthcare';
        setCookie('company-mode', company, 365);

       
        // Change lang in dropdown
        company_switch.children('.dropdown-toggle').html(
            $('.healthcare').html() + ' <i class="caret" />'
        );

        // Set active class
        company_switch.find('li').removeClass('active');
        $('.healthcare').parent().addClass('active');

        location.reload();

    });

    $('.dfad').on('click', function () {

        let company = 'dfad';
        setCookie('company-mode', company, 365);

       
        // Change lang in dropdown
        company_switch.children('.dropdown-toggle').html(
            $('.dfad').html() + ' <i class="caret" />'
        );

        // Set active class
        company_switch.find('li').removeClass('active');
        $('.dfad').parent().addClass('active');
        location.reload();

    });

    $('.petro').on('click', function () {

        let company = 'petro';
        setCookie('company-mode', company, 365);

       
        // Change lang in dropdown
        company_switch.children('.dropdown-toggle').html(
            $('.petro').html() + ' <i class="caret" />'
        );

        // Set active class
        company_switch.find('li').removeClass('active');
        $('.petro').parent().addClass('active');
        location.reload();
        
    });

    $('.afaq').on('click', function () {

        let company = 'afaq';
        setCookie('company-mode', company, 365);

       
        // Change lang in dropdown
        company_switch.children('.dropdown-toggle').html(
            $('.afaq').html() + ' <i class="caret" />'
        );

        // Set active class
        company_switch.find('li').removeClass('active');
        $('.afaq').parent().addClass('active');
        location.reload();
        
    });


});
