<div id="cp_form_cont" class="modal fade" style="display: none;">
	<div class="modal-dialog modal-full">
		<div class="modal-content">
			<form class="form-horizontal" method="post" name="cp_form" id="cp_form" enctype="multipart/form-data">
				<input type="hidden" name="cp_prefix" id="cp_prefix" value="cp_">

				<div class="panel-heading">
					<h6 class="panel-title"><span class="" data-i18n="page.patient.edit">Add New Patient</span> <a class="heading-elements-toggle"><i class="icon-pencil7"></i></a></h6>
					<div class="heading-elements">

						<button type="button" class="close" data-dismiss="modal"><i class="icon-cross"></i></button>
					</div>
				</div>

				<div class="panel-body">
					<div class="tabbable tab-content-bordered">
						<ul class="nav nav-tabs nav-tabs-highlight nav-justified">
							<li class="cp-li-tabs active" id="cp_active-tab">
								<a href="#cp-bordered-justified-tab1" data-toggle="tab">
									<i class="icon-pencil7 position-left"></i>
									<span class="" data-i18n="page.patient.info">
										المعلومات الاساسية
									</span>
								</a>
							</li>

						</ul>



						<div class="tab-content">
							<div class="tab-pane cp-li-tabs has-padding active" id="cp-bordered-justified-tab1">

								<div class="form-group">

									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label " data-i18n="page.patient.role">First Name</label>
										<input type="text" data-i18n="[placeholder]page.patient.role" placeholder="First Name" class="form-control " name="cp_first_name" id="cp_first_name" required="required">
										<ul class="searchResult" id="cp_first_name_searchResult"></ul>
									</div>

									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label " data-i18n="page.patient.role">Second Name</label>
										<input type="text" data-i18n="[placeholder]page.patient.role" placeholder="Second Name" class="form-control " name="cp_second_name" id="cp_second_name">
										<ul class="searchResult" id="cp_second_name_searchResult"></ul>
									</div>

									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label " data-i18n="page.patient.role">Third Name/Surename</label>
										<input type="text" data-i18n="[placeholder]page.patient.role" placeholder="Third Name/Surename" class="form-control " name="cp_third_name" id="cp_third_name" required="required">
										<ul class="searchResult" id="cp_third_name_searchResult"></ul>
									</div>

									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label " data-i18n="page.patient.role">Patient Name</label>
										<input type="text" data-i18n="[placeholder]page.patient.role" placeholder="Patient Name" class="form-control " name="cp_patient_full_name" id="cp_patient_full_name" required="required" readonly>
									</div>

									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label " data-i18n="page.patient.role">Mobile Number</label>
										<input type="text" data-i18n="[placeholder]page.patient.role" placeholder="Mobile Number" class="form-control " name="cp_patient_phone" id="cp_patient_phone" required="required">
									</div>

									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label " data-i18n="page.patient.role">Address</label>
										<input type="text" data-i18n="[placeholder]page.patient.role" placeholder="Address" class="form-control " name="cp_patient_address" id="cp_patient_address">
									</div>



									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label " data-i18n="page.patient.role">E-Mail</label>
										<input type="text" data-i18n="[placeholder]page.patient.role" placeholder="E-Mail" class="form-control " name="cp_patient_email" id="cp_patient_email">
									</div>

									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label " data-i18n="page.patient.role">Card ID/Passport No.</label>
										<input type="text" data-i18n="[placeholder]page.patient.role" placeholder="Card ID/Passport No." class="form-control " name="cp_patient_card_number" id="cp_patient_card_number">
									</div>

									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label " data-i18n="page.patient.role">Date of Birth</label>
										<input type="text" data-i18n="[placeholder]page.patient.role" placeholder="Date of Birth" class="form-control daterange-single" name="cp_patient_date_of_birth" id="cp_patient_date_of_birth">
									</div>


									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label " data-i18n="page.patient.role">Gender</label>
										<select class="form-control stop_enter" name="cp_gender" id="cp_gender" data-width="100%" data-live-search="true">
											<option value="Male" data-i18n="page.patient.role">Male</option>
											<option value="Female" data-i18n="page.patient.role">Female</option>
										</select>
									</div>

									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label " data-i18n="page.patient.role">Blood Group</label>
										<select class="form-control stop_enter" name="cp_blood_group" id="cp_blood_group" data-width="100%" data-live-search="true">
											<option value="" data-i18n="page.patient.role">Select</option>
											<option value="A+" data-i18n="page.patient.role">A+</option>
											<option value="A-" data-i18n="page.patient.role">A-</option>
											<option value="B+" data-i18n="page.patient.role">B+</option>
											<option value="B-" data-i18n="page.patient.role">B-</option>
											<option value="O+" data-i18n="page.patient.role">O+</option>
											<option value="O-" data-i18n="page.patient.role">O-</option>
											<option value="AB+" data-i18n="page.patient.role">AB+</option>
											<option value="AB-" data-i18n="page.patient.role">AB-</option>
										</select>
									</div>

									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label " data-i18n="page.patient.role">Allergies</label>
										<input type="text" data-i18n="[placeholder]page.patient.role" placeholder="Allergies" class="form-control " name="cp_allergies" id="cp_allergies">
									</div>



									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label " data-i18n="page.patient.role">Insurance status</label>
										<select class="form-control stop_enter" name="cp_insurance" id="cp_insurance" data-width="100%" data-live-search="true" required>
											<option value="" data-i18n="page.patient.role"></option>
											<option value="No insurance" data-i18n="page.patient.role">No insurance</option>
											<option value="Insurance covered" data-i18n="page.patient.role">Insurance covered</option>
											<option value="Share Holder" data-i18n="page.patient.role">Share Holder</option>
											<option value="Pre Employment" data-i18n="page.patient.role">Pre Employment</option>

										</select>
									</div>

									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label " data-i18n="page.patient.role">Company</label>
										<select class="form-control stop_enter" name="cp_company_id_fk" id="cp_company_id_fk" data-width="100%" data-live-search="true">

										</select>
									</div>

									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label " data-i18n="page.patient.role">Insurance Company</label>
										<select class="form-control stop_enter" name="cp_insurance_company_id_fk" id="cp_insurance_company_id_fk" data-width="100%" data-live-search="true">

										</select>
									</div>

									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label " data-i18n="page.patient.role">Occupation</label>
										<input type="text" data-i18n="[placeholder]page.patient.role" placeholder="Occupation" class="form-control " name="cp_occupation" id="cp_occupation">
									</div>

									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label " data-i18n="page.patient.role">Group</label>
										<select class="form-control stop_enter" name="cp_patient_group_id_fk" id="cp_patient_group_id_fk" data-width="100%" data-live-search="true">

										</select>
									</div>


									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label " data-i18n="page.patient.role">Country</label>
										<select class="form-control stop_enter" name="cp_country_name" id="cp_country_name" data-width="100%" data-live-search="true">

										</select>
									</div>

									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label " data-i18n="page.patient.role">City</label>
										<select class="form-control stop_enter" name="cp_city_name" id="cp_city_name" data-width="100%" data-live-search="true">

										</select>
									</div>




									<div class="form-group has-feedback has-feedback-left col-lg-3 col-md-6 col-sm-6 col-xs-12">
										<label class="control-label" data-i18n="page.patient.role">Patient Image</label>
										<input type="file" class="file-styled" id="cp_patient_img" name="cp_patient_img">
										<span class="help-block">Accepted formats: gif, png, jpg. Max file size 2Mb</span>
									</div>





									<div class="form-group has-feedback has-feedback-right col-lg-12 col-md-12 col-sm-12 col-xs-12">
										<label class="control-label" data-i18n="page.patient.info">Note</label>
										<textarea type="text" data-i18n="[placeholder]page.patient.info" placeholder="Note" class="form-control" name="cp_patient_note" id="cp_patient_note"></textarea>

									</div>

								</div>

							</div>




						</div>

					</div>
				</div>

				<div class="panel-footer"><a class="heading-elements-toggle"><i class="icon-more"></i></a>
					<div class="heading-elements">
						<!-- <span class="heading-text text-semibold ">Actions</span> -->
						<div class="col-lg-12">
							<button type="button" id="submit_cp_btn" class="btn btn-primary pull-left legitRipple btn-labeled btn-labeled-left"><span class="" data-i18n="page.patient.save">Save</span><b><i class="icon-floppy-disk"></i></b>
							</button>

							<button type="submit" id="submit_cp_btn_triger" style="display: none;"></button>

							<button type="button" id="cp_form_cancel" class="btn btn-danger pull-right legitRipple btn-labeled btn-labeled-left" data-dismiss="modal">
								<span class="" data-i18n="page.patient.close">Close</span><b><i class="icon-cancel-square"></i></b>

							</button>

						</div>
					</div>
				</div>
			</form>
		</div>


	</div>
</div>

<div id="file-previewer" class="modal fade" style="display: none;">
	<div class="modal-dialog modal-full">
		<form class="form-horizontal" name="file-previewer-form" method="post" id="file-previewer-form" enctype="multipart/form-data">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal"><i class="icon-cross"></i></button>
					<h4 class="modal-title multi_lang">Preview</h4>
				</div>

				<div class="modal-body">
					<input type="hidden" name="table_name_img" id="table_name_img" value="">
					<input type="hidden" name="image_file_id" id="image_file_id" value="">
					<input type="hidden" name="image_field_name" id="image_field_name" value="">
					<input type="hidden" name="primary_key_name" id="primary_key_name" value="">

					<div class="form-group">

						<div class="form-group has-feedback has-feedback-left col-lg-12 col-md-12 col-sm-12 col-xs-12">
							<img id="img-modal_preview" class="img-previewer-full" src="#" />

						</div>

					</div>

				</div>
				<div class="modal-footer">
					<button type="submit" id="delete-img" class="btn pull-right btn-labeled btn-labeled-left heading-btn btn-danger"> <span class="multi_lang">Delete Image</span> <b><i class="icon-trash"></i></b>
					</button>
					<button type="button" class="btn pull-left btn-primary multi_lang" data-dismiss="modal"> Cancel
					</button>
				</div>
			</div>
		</form>
	</div>
</div>

<div id="file-previewer-multi" class="modal fade" style="display: none;">
	<div class="modal-dialog modal-full">
		<form class="form-horizontal" name="file-previewer-multi-form" method="post" id="file-previewer-multi-form" enctype="multipart/form-data">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal"><i class="icon-cross"></i></button>
					<h4 class="modal-title multi_lang">Preview</h4>
				</div>

				<div class="modal-body" id="preview-multi">



				</div>
				<div class="modal-footer">

					<button type="button" class="btn pull-left btn-primary multi_lang" data-dismiss="modal">
						<span>Close</span>
					</button>
				</div>
			</div>
		</form>
	</div>
</div>

<div id="log-previewer" class="modal fade" style="display: none;">
	<div class="modal-dialog modal-full">

		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><i class="icon-cross"></i></button>
				<h4 class="modal-title multi_lang">Log Preview</h4>
			</div>

			<div class="modal-body">

				<div class="row">

					<div class="col-lg-12" id="log-previewer-div">


					</div>

				</div>

			</div>

			<div class="modal-footer">

				<button type="button" class="btn pull-left btn-primary multi_lang" data-dismiss="modal"> Close
				</button>

			</div>
		</div>

	</div>
</div>

<div id="report-view-modal" class="modal fade" style="display: none;">
	<div class="modal-dialog modal-full">
		<div class="modal-content">


			<div class="panel-heading">
				<h6 class="panel-title"><span class="" data-i18n="page.patient.edit">View</span> <a class="heading-elements-toggle"><i class="icon-chart"></i></a></h6>
				<div class="heading-elements">

					<button type="button" class="close" data-dismiss="modal"><i class="icon-cross"></i></button>
				</div>
			</div>

			<div class="panel-body">
				<div class="tabbable tab-content-bordered">
					<ul class="nav nav-tabs nav-tabs-highlight nav-justified">
						<li class="report-view-li-tabs active" id="report-view_active-tab">
							<a href="#report-view-bordered-justified-tab1" data-toggle="tab">
								<i class="icon-printer4 position-left"></i>
								<span class="" data-i18n="page.patient.info" id="report-view-title">
									Salary Sheet
								</span>
							</a>
						</li>

					</ul>



					<div class="tab-content">
						<div class="tab-pane report-view-li-tabs has-padding active" id="report-view-bordered-justified-tab1">

							<div class="table-responsive1" id="report-view_table">

							</div>

						</div>




					</div>

				</div>
			</div>

			<div class="panel-footer"><a class="heading-elements-toggle"><i class="icon-more"></i></a>
				<div class="heading-elements">
					<!-- <span class="heading-text text-semibold ">Actions</span> -->
					<div class="col-lg-12">
						<button type="button" id="report-print_btn" class="btn btn-primary pull-left legitRipple btn-labeled btn-labeled-left"><span class="" data-i18n="page.patient.save">Print</span><b><i class="icon-printer"></i></b>
						</button>

						<button type="button" id="report-view_form_cancel" class="btn btn-danger pull-right legitRipple btn-labeled btn-labeled-left" data-dismiss="modal">
							<span class="" data-i18n="page.patient.close">Close</span><b><i class="icon-cancel-square"></i></b>

						</button>

					</div>
				</div>
			</div>
		</div>


	</div>
</div>

<div id="view-modal" class="modal fade" style="display: none;">
	<div class="modal-dialog modal-full">
		<div class="modal-content">


			<div class="panel-heading">
				<h6 class="panel-title"><span class="" data-i18n="page.patient.edit">View</span> <a class="heading-elements-toggle"><i class="icon-pencil7"></i></a></h6>
				<div class="heading-elements">

					<button type="button" class="close" data-dismiss="modal"><i class="icon-cross"></i></button>
				</div>
			</div>

			<div class="panel-body">


				<div class="tabbable tab-content-bordered">
					<ul class="nav nav-tabs nav-tabs-highlight nav-justified">
						<li class="view-li-tabs active" id="view_active-tab">
							<a href="#view-bordered-justified-tab1" data-toggle="tab">
								<i class="icon-printer4 position-left"></i>
								<span class="" data-i18n="page.patient.info" id="view-title">
									Salary Sheet
								</span>
							</a>
						</li>

					</ul>



					<div class="tab-content">
						<div class="tab-pane view-li-tabs has-padding active" id="view-bordered-justified-tab1">

							<div class="table-responsive1" id="view_table">

							</div>

							<div class="table-responsive1 hide-div" id="view_table_usd">

							</div>

						</div>




					</div>

				</div>
			</div>

			<div class="panel-footer"><a class="heading-elements-toggle"><i class="icon-more"></i></a>
				<div class="heading-elements">
					<!-- <span class="heading-text text-semibold ">Actions</span> -->
					<div class="col-lg-12">
						<button type="button" id="print_btn" class="btn btn-primary pull-left legitRipple btn-labeled btn-labeled-left"><span class="" data-i18n="page.patient.save">Print</span><b><i class="icon-printer"></i></b>
						</button>

						<div id="mpdf_btn"></div>
						<div id="extra_space" style="margin-left: 120px; margin-right:120px;">

						</div>
						<button type="button" id="view_form_cancel" class="btn btn-danger pull-right legitRipple btn-labeled btn-labeled-left" data-dismiss="modal">
							<span class="" data-i18n="page.patient.close">Close</span><b><i class="icon-cancel-square"></i></b>

						</button>

					</div>
				</div>
			</div>
		</div>


	</div>
</div>


<div id="view-modal-pr" class="modal fade" style="display: none;">
	<div class="modal-dialog modal-full">
		<div class="modal-content">


			<div class="panel-heading">
				<h6 class="panel-title"><span class="" data-i18n="page.patient.edit">View</span> <a class="heading-elements-toggle"><i class="icon-pencil7"></i></a></h6>
				<div class="heading-elements">

					<button type="button" class="close" data-dismiss="modal"><i class="icon-cross"></i></button>
				</div>
			</div>

			<div class="panel-body">


				<div class="tabbable tab-content-bordered">
					<ul class="nav nav-tabs nav-tabs-highlight nav-justified">
						<li class="view-li-tabs active" id="view_active-tab">
							<a href="#view-bordered-justified-tab1" data-toggle="tab">
								<i class="icon-printer4 position-left"></i>
								<span class="" data-i18n="page.patient.info" id="view-title-pr">
									Patient Report
								</span>
							</a>
						</li>

					</ul>



					<div class="tab-content">
						<div class="tab-pane view-li-tabs has-padding active" id="view-bordered-justified-tab1">

							<div class="table-responsive1" id="view_table_pr">

								<table width="100%" border=0 cellpadding=0 cellspacing=0>
									<tr>
										<td>
											<br>
											<div class="part_1">
											</div>
											<br>
										</td>
									</tr>
									<tr>
										<td>
											<br>
											<div class="part_2">
											</div>
											<br>
										</td>
									</tr>
									<tr>
										<td>
											<br>
											<div class="part_3">
											</div>
											<br>
										</td>
									</tr>
									<tr>
										<td>
											<br>
											<div class="part_4">
											</div>
											<br>
										</td>
									</tr>
									<tr class="border">
										<td class="font-bold nbl nbb bg-success text-center text-lg">Investigations/Lab</td>
									</tr>
									<tr>
										<td>
											<br>
											<div class="part_5">
												<div id="tabs_lab"></div>
												<div id="contents_lab"></div>
											</div>
											<br>
										</td>
									</tr>

									<tr class="border">
										<td class="font-bold nbl nbb bg-success text-center text-lg">Investigations/Radiology</td>
									</tr>
									<tr>
										<td>
											<br>
											<div class="part_6">
												<div id="tabs_rad"></div>
												<div id="contents_rad"></div>
											</div>
											<br>
										</td>
									</tr>

									<tr class="border">
										<td class="font-bold nbl nbb bg-success text-center text-lg">Consultation</td>
									</tr>
									<tr>
										<td>
											<br>
											<div class="part_7">
												<div id="tabs_con"></div>
												<div id="contents_con"></div>
											</div>
											<br>
										</td>
									</tr>

									<tr class="border">
										<td class="font-bold nbl nbb bg-success text-center text-lg">Procedures & Services</td>
									</tr>
									<tr>
										<td>
											<br>
											<div class="part_8">
												<div id="tabs_ser"></div>
												<div id="contents_ser"></div>
											</div>
											<br>
										</td>
									</tr>
									<tr>
										<td>
											<br>
											<div class="part_9">
											</div>
											<br>
										</td>
									</tr>

									<tr class="border">
										<td colspan="3" class="font-bold nbl nbb bg-success text-center">
											Treatment <span style="font-style: italic;">(Dose and route)</span>
										</td>
									</tr>
									<tr>
										<td>
											<br>
											<div class="part_10">
												<div id="tabs_trt"></div>
												<div id="contents_trt"></div>
											</div>
											<br>
										</td>
									</tr>

									<tr class="border">
										<td colspan="3" class="font-bold nbl nbb bg-success text-center">
											Doctors, Nurse & Tour Notes
										</td>
									</tr>
									<tr>
										<td>
											<br>
											<div class="part_11">
												<div id="tabs_tor"></div>
												<div id="contents_tor"></div>
											</div>
											<br>
										</td>
									</tr>
									<tr>
										<td>
											<br>
											<div class="part_12">
											</div>
											<br>
										</td>
									</tr>
									<tr>
										<td>
											<br>
											<div class="part_13">
											</div>
											<br>
										</td>
									</tr>
									<tr>
										<td>
											<br>
											<div class="part_14">
											</div>
											<br>
										</td>
									</tr>
								</table>



							</div>



						</div>




					</div>

				</div>
			</div>

			<div class="panel-footer"><a class="heading-elements-toggle"><i class="icon-more"></i></a>
				<div class="heading-elements">
					<!-- <span class="heading-text text-semibold ">Actions</span> -->
					<div class="col-lg-12">
						<button type="button" id="print_btn" class="btn btn-primary pull-left legitRipple btn-labeled btn-labeled-left"><span class="" data-i18n="page.patient.save">Print</span><b><i class="icon-printer"></i></b>
						</button>
						<div id="extra_space" style="margin-left: 120px; margin-right:120px;">

						</div>
						<button type="button" id="view_form_cancel" class="btn btn-danger pull-right legitRipple btn-labeled btn-labeled-left" data-dismiss="modal">
							<span class="" data-i18n="page.patient.close">Close</span><b><i class="icon-cancel-square"></i></b>

						</button>

					</div>
				</div>
			</div>
		</div>


	</div>
</div>



<script>
	function previewFullImage(id, path, table, pri_key, field_name) {
		$("#table_name_img").val(table);
		$("#image_file_id").val(id);
		$("#image_field_name").val(field_name);
		$("#primary_key_name").val(pri_key);
		$('#img-modal_preview').attr('src', path);
		$('#file-previewer').modal('toggle');

	}

	function deleteImage(itemid, table, pri_key, field_name) {

		swal({
				title: i18n.t("هل انت متأكد؟!"),
				text: i18n.t("سيتم حذف الملف من قاعدة البيانات ومن ملفات الخادم"),
				type: "warning",
				showCancelButton: true,
				confirmButtonColor: "#EF5350",
				confirmButtonText: i18n.t("موافق: امسح!"),
				cancelButtonText: i18n.t("الغاء الامر"),
				closeOnConfirm: false,
				closeOnCancel: true
			},
			function(isConfirm) {
				if (isConfirm) {
					$.ajax({
						url: "models/crul_user.php",
						type: "POST",
						dataType: "JSON",
						data: {
							"type": "delete-img",
							"id": itemid,
							"table": table,
							"pri_key": pri_key,
							"field_name": field_name
						},
						complete: function() {

						},
						beforeSend: function() {

						},
						success: function(res) {

							if (res.is_success == true) {
								swal({
									title: i18n.t("حذف!"),
									text: i18n.t(res.data),
									confirmButtonColor: "#66BB6A",
									type: "success"
								});
								$('#file-previewer').modal('toggle');

								$(".datatable-column-search-inputs").DataTable().ajax.reload(null, false);
							} else {
								swal({
									title: "Cancelled",
									text: i18n.t(res.data),
									confirmButtonColor: "#2196F3",
									type: "error"
								});
							}
						}
					});
				}
			}); // /confirm
	}

	function get_User_log(itemid) {

		$.ajax({
			url: "models/crul_user.php",
			type: "POST",
			dataType: "JSON",
			data: {
				"type": "get_user_log",
				"id": itemid,

			},
			complete: function() {

			},
			beforeSend: function() {

			},
			success: function(response) {


				if (response.is_success == true) {



					$("#log-previewer-div").html('');

					var $tbl = `<table class="table table-bordered table-striped table-hover bg-info-700">
		            				<thead>
										<tr>
											<th>ID</th>
											<th>Type</th>
											<th>Table Name</th>
											<th>Primary ID Key</th>
											<th>Action</th>
											<th>Page Name</th>
											<th>Time</th>
											<th>Username</th>
										</tr>
									</thead>
		            `;

					for (var i = 0; i < response.data.length; i++) {




						$tbl += `<tr>
		                			<td>${response.data[i].log_id}</td>
		                			<td>${response.data[i].log_type}</td>
		                			<td>${response.data[i].log_table_name}</td>
		                			<td>${response.data[i].log_primary_id_fk}</td>
		                			<td>${response.data[i].log_action}</td>
		                			<td>${response.data[i].page_name}</td>
		                			<td>${response.data[i].log_timestamp}</td>
		                			<td>${response.data[i].username}</td>
		                		</tr>`;




					}

					$tbl += `</table>`;

					// console.log(mockData)
					$('#log-previewer-div').html($tbl);


					$('#log-previewer').modal('toggle');

				} else {

					swal({
						title: i18n.t("Error"),
						text: i18n.t(response.data),
						confirmButtonColor: "#2196F3",
						type: "error"
					});

				}

			}
		});


	}

	function get_log(itemid, tbl_name) {

		$.ajax({
			url: "models/crul_user.php",
			type: "POST",
			dataType: "JSON",
			data: {
				"type": "get_log",
				"id": itemid,
				"table": tbl_name,

			},
			complete: function() {

			},
			beforeSend: function() {

			},
			success: function(response) {


				if (response.is_success == true) {



					$("#log-previewer-div").html('');

					var $tbl = `<table class="table table-bordered table-striped table-hover bg-info-700">
		            				<thead>
										<tr class="bg-warning">
											<th>ID</th>
											<th>Type</th>
											<th>Table Name</th>
											<th>Primary ID Key</th>
											<th>Action</th>
											<th>Page Name</th>
											<th>Time</th>
											<th>Username</th>
										</tr>
									</thead>
		            `;

					for (var i = 0; i < response.data.length; i++) {




						$tbl += `<tr>
		                			<td>${response.data[i].log_id}</td>
		                			<td>${response.data[i].log_type}</td>
		                			<td>${response.data[i].log_table_name}</td>
		                			<td>${response.data[i].log_primary_id_fk}</td>
		                			<td>${response.data[i].log_action}</td>
		                			<td>${response.data[i].page_name}</td>
		                			<td>${response.data[i].log_timestamp}</td>
		                			<td>${response.data[i].username}</td>
		                		</tr>`;




					}

					$tbl += `</table>`;

					// console.log(mockData)
					$('#log-previewer-div').html($tbl);


					$('#log-previewer').modal('toggle');

				} else {

					swal({
						title: i18n.t("Error"),
						text: i18n.t(response.data),
						confirmButtonColor: "#2196F3",
						type: "error"
					});

				}

			}
		});


	}

	function get_Country(prefix = '') {

		$.ajax({
			url: 'models/crul_user.php',
			type: 'POST',
			data: {
				type: 'get_country'
			},
			dataType: 'json',
			success: function(res) {
				var attach = '<option value="" >' + i18n.t('Select Country') + '</option>';

				for (var i = 0; i < res.data.length; i++) {

					attach += `<option data-cc="${res.data[i].country_code}" value="${res.data[i].name}">${res.data[i].name}</option>`;

				}


				$("#" + prefix + "country_name").html(attach);
				$("#edit_country_name").html(attach);
				$("#" + prefix + "country_name").val('Iraq').selectpicker('refresh');
				$("#edit_country_name").selectpicker('refresh');
				get_City('IQ', null, prefix)
			},
			complete: function() {
				//  me.data('requestRunning', false);
			}

		}); // submit ajax

	}

	function get_City(cc = 'IQ', city_name = null, prefix = '') {

		$.ajax({
			url: 'models/crul_user.php',
			type: 'POST',
			data: {
				type: 'get_city',
				country_code: cc
			},
			dataType: 'json',
			success: function(res) {
				var attach = '<option value="" >' + i18n.t('Select City') + '</option>';

				for (var i = 0; i < res.data.length; i++) {

					attach += `<option value="${res.data[i].city_name}">${res.data[i].city_name}</option>`;

				}


				$("#" + prefix + "city_name").html(attach);
				$("#edit_city_name").html(attach);
				$("#" + prefix + "city_name").selectpicker('refresh');
				if (city_name != null) {
					$("#edit_city_name").val(city_name).selectpicker('refresh');
				} else {
					$("#edit_city_name").selectpicker('refresh');
				}

			},
			complete: function() {
				//  me.data('requestRunning', false);
			}

		}); // submit ajax

	}

	function get_Company(prefix = '') {

		$.ajax({
			url: 'models/crul_company.php',
			type: 'POST',
			data: {
				type: 'get'
			},
			dataType: 'json',
			success: function(res) {
				var attach = `<option value="0">${i18n.t('Normal Patient')}</option>`;

				for (var i = 0; i < res.data.length; i++) {

					attach += `<option value="${res.data[i].company_id}">${res.data[i].company_name}</option>`;

				}


				$("#" + prefix + "company_id_fk").html(attach);
				$("#edit_company_id_fk").html(attach);
				$("#" + prefix + "company_id_fk").selectpicker('refresh');
				$("#edit_company_id_fk").selectpicker('refresh');

			},
			complete: function() {
				//  me.data('requestRunning', false);
			}

		}); // submit ajax

	}

	function get_Insurance_Company(prefix = '') {

		$.ajax({
			url: 'models/crul_insurance_company.php',
			type: 'POST',
			data: {
				type: 'get'
			},
			dataType: 'json',
			success: function(res) {
				var attach = `<option value="0">${i18n.t('Select Insurance Company')}</option>`;

				for (var i = 0; i < res.data.length; i++) {

					attach += `<option value="${res.data[i].insurance_company_id}">${res.data[i].insurance_company_name}</option>`;

				}


				$("#" + prefix + "insurance_company_id_fk").html(attach);
				$("#edit_insurance_company_id_fk").html(attach);
				$("#" + prefix + "insurance_company_id_fk").selectpicker('refresh');
				$("#edit_insurance_company_id_fk").selectpicker('refresh');

			},
			complete: function() {
				//  me.data('requestRunning', false);
			}

		}); // submit ajax

	}

	function get_Patient_Group(prefix = '') {

		$.ajax({
			url: 'models/crul_patient_group.php',
			type: 'POST',
			data: {
				type: 'get'
			},
			dataType: 'json',
			success: function(res) {
				var attach = `<option value="0">${i18n.t('General')}</option>`;

				for (var i = 0; i < res.data.length; i++) {

					attach += `<option value="${res.data[i].patient_group_id}">${res.data[i].patient_group_name}</option>`;

				}


				$("#" + prefix + "patient_group_id_fk").html(attach);
				$("#edit_patient_group_id_fk").html(attach);
				$("#" + prefix + "patient_group_id_fk").selectpicker('refresh');
				$("#edit_patient_group_id_fk").selectpicker('refresh');

			},
			complete: function() {
				//  me.data('requestRunning', false);
			}

		}); // submit ajax

	}

	function init_select2(id) {
		$(`select[name^="${id}"]`).select2({
			minimumResultsForSearch: -1,
			ajax: {
				url: "models/crul_product.php",
				dataType: 'json',
				type: 'POST',
				quietMillis: 100,
				data: function(data, page) {
					return {
						type: 'search',
						dataType: '',
						condition: '',
						category: '',
						q: data.term,
						page_limit: 8,
						page: 10
					};
				},
				processResults: function(data, params) {
					params.page = params.page || 1;
					if (data.length > 0) {
						var results = [];
						$.each(data, function(index, item) {
							// console.log(item)
							results.push({
								id: item.product_id,
								text: item.product_name,
								data_unit_id: item.product_unit_id_fk,
								data: item
							});
						});
						return {
							results: results,
							pagination: {
								more: (params.page * 30) < data.length
							}
						};
					}
				}
			},
			escapeMarkup: function(markup) {
				return markup;
			},
			templateResult: function(res) {
				if (res.loading) {
					return res.text;
				}
				if (res.data.product_id == 0) {
					return `
	                    <div class="media">
	                        <div class="media-left media-middle">
	                            <a href="#" class="btn bg-pink-400 btn-rounded btn-icon btn-xlg">
	                                <span class="">${res.data.product_id}</span>
	                            </a>
	                        </div>
	                        <div class="media-body">
	                            <div class="media-heading">
	                                <a href="#" class="letter-icon-title">${res.data.product_name}</a>
	                            </div>
	                        </div>
	                    </div>
	                `;
				} else {
					return `
	                    <div class="media">
	                        <div class="media-left media-middle">
	                            <a href="#" class="btn bg-pink-400 btn-rounded btn-icon btn-xlg">
	                                <span class="">${res.data.product_id}</span>
	                            </a>
	                        </div>
	                        <div class="media-body">
	                            <p>${res.data.product_name}</p>
	                            <p>${res.data.product_barcode}</p>
	                        </div>
	                    </div>
	                `;
				}
			},
			templateSelection: function(data, container) {
				console.error(data)
				// $(data.element).attr('data-custom-attribute', data.product_unit_id_fk);
				return data.product_id || data.text;
			},
			minimumInputLength: 2,
			placeholder: "Search Name, Barcode, Batch No.",

		});
	}

	function init_select2_lab_device(id, requestType) {
		$(`select[name^="${id}"]`).select2({
			minimumResultsForSearch: -1,
			ajax: {
				url: "models/crul_product.php",
				dataType: 'json',
				type: 'POST',
				quietMillis: 100,
				data: function(data, page) {
					return {
						type: requestType,
						pid: $(`select[name^="product_type_id_fk"]`).val(),
						dataType: '',
						condition: '',
						category: '',
						q: data.term,
						page_limit: 8,
						page: 10
					};
				},
				processResults: function(data, params) {
					params.page = params.page || 1;
					if (data.length > 0) {
						var results = [];
						$.each(data, function(index, item) {
							// console.log(item)
							results.push({
								id: item.product_id,
								text: item.product_name,
								data_unit_id: item.product_unit_id_fk,
								data: item
							});
						});
						return {
							results: results,
							pagination: {
								more: (params.page * 30) < data.length
							}
						};
					}
				}
			},
			escapeMarkup: function(markup) {
				return markup;
			},
			templateResult: function(res) {
				if (res.loading) {
					return res.text;
				}
				if (res.data.product_id == 0) {
					return `
	                    <div class="media">
	                        <div class="media-left media-middle">
	                            <a href="#" class="btn bg-pink-400 btn-rounded btn-icon btn-xlg">
	                                <span class="">${res.data.product_id}</span>
	                            </a>
	                        </div>
	                        <div class="media-body">
	                            <div class="media-heading">
	                                <a href="#" class="letter-icon-title">${res.data.product_name}</a>
	                            </div>
	                        </div>
	                    </div>
	                `;
				} else {
					return `
	                    <div class="media">
	                        <div class="media-left media-middle">
	                            <a href="#" class="btn bg-pink-400 btn-rounded btn-icon btn-xlg">
	                                <span class="">${res.data.product_id}</span>
	                            </a>
	                        </div>
	                        <div class="media-body">
	                            <p>${res.data.product_name}</p>
	                            <p>${res.data.product_barcode}</p>
	                        </div>
	                    </div>
	                `;
				}
			},
			templateSelection: function(data, container) {
				console.error(data)
				// $(data.element).attr('data-custom-attribute', data.product_unit_id_fk);
				return data.product_id || data.text;
			},
			minimumInputLength: 2,
			placeholder: "Search Name, Barcode, Batch No.",

		});
	}

	function init_select2_rad(id) {
		$(`select[name^="${id}"]`).select2({
			minimumResultsForSearch: -1,
			ajax: {
				url: "models/crul_product.php",
				dataType: 'json',
				type: 'POST',
				quietMillis: 100,
				data: function(data, page) {
					return {
						type: 'search',
						dataType: '',
						condition: '',
						category: '6',
						q: data.term,
						page_limit: 8,
						page: 10
					};
				},
				processResults: function(data, params) {
					params.page = params.page || 1;
					if (data.length > 0) {
						var results = [];
						$.each(data, function(index, item) {
							// console.log(item)
							results.push({
								id: item.product_id,
								text: item.product_name,
								data_unit_id: item.product_unit_id_fk,
								data: item
							});
						});
						return {
							results: results,
							pagination: {
								more: (params.page * 30) < data.length
							}
						};
					}
				}
			},
			escapeMarkup: function(markup) {
				return markup;
			},
			templateResult: function(res) {
				if (res.loading) {
					return res.text;
				}
				if (res.data.product_id == 0) {
					return `
	                    <div class="media">
	                        <div class="media-left media-middle">
	                            <a href="#" class="btn bg-pink-400 btn-rounded btn-icon btn-xlg">
	                                <span class="">${res.data.product_id}</span>
	                            </a>
	                        </div>
	                        <div class="media-body">
	                            <div class="media-heading">
	                                <a href="#" class="letter-icon-title">${res.data.product_name}</a>
	                            </div>
	                        </div>
	                    </div>
	                `;
				} else {
					return `
	                    <div class="media">
	                        <div class="media-left media-middle">
	                            <a href="#" class="btn bg-pink-400 btn-rounded btn-icon btn-xlg">
	                                <span class="">${res.data.product_id}</span>
	                            </a>
	                        </div>
	                        <div class="media-body">
	                            <p>${res.data.product_name}</p>
	                            <p>${res.data.product_barcode}</p>
	                        </div>
	                    </div>
	                `;
				}
			},
			templateSelection: function(data, container) {
				console.error(data)
				// $(data.element).attr('data-custom-attribute', data.product_unit_id_fk);
				return data.product_id || data.text;
			},
			minimumInputLength: 2,
			placeholder: "Search Name, Barcode, Batch No.",

		});
	}

	function init_select2_lab(id) {
		$(`select[name^="${id}"]`).select2({
			minimumResultsForSearch: -1,
			ajax: {
				url: "models/crul_product.php",
				dataType: 'json',
				type: 'POST',
				quietMillis: 100,
				data: function(data, page) {
					return {
						type: 'search',
						dataType: '',
						condition: '',
						category: '1',
						q: data.term,
						page_limit: 8,
						page: 10
					};
				},
				processResults: function(data, params) {
					params.page = params.page || 1;
					if (data.length > 0) {
						var results = [];
						$.each(data, function(index, item) {
							// console.log(item)
							results.push({
								id: item.product_id,
								text: item.product_name,
								data_unit_id: item.product_unit_id_fk,
								data: item
							});
						});
						return {
							results: results,
							pagination: {
								more: (params.page * 30) < data.length
							}
						};
					}
				}
			},
			escapeMarkup: function(markup) {
				return markup;
			},
			templateResult: function(res) {
				if (res.loading) {
					return res.text;
				}
				if (res.data.product_id == 0) {
					return `
	                    <div class="media">
	                        <div class="media-left media-middle">
	                            <a href="#" class="btn bg-pink-400 btn-rounded btn-icon btn-xlg">
	                                <span class="">${res.data.product_id}</span>
	                            </a>
	                        </div>
	                        <div class="media-body">
	                            <div class="media-heading">
	                                <a href="#" class="letter-icon-title">${res.data.product_name}</a>
	                            </div>
	                        </div>
	                    </div>
	                `;
				} else {
					return `
	                    <div class="media">
	                        <div class="media-left media-middle">
	                            <a href="#" class="btn bg-pink-400 btn-rounded btn-icon btn-xlg">
	                                <span class="">${res.data.product_id}</span>
	                            </a>
	                        </div>
	                        <div class="media-body">
	                            <p>${res.data.product_name}</p>
	                            <p>${res.data.product_barcode}</p>
	                        </div>
	                    </div>
	                `;
				}
			},
			templateSelection: function(data, container) {
				console.error(data)
				// $(data.element).attr('data-custom-attribute', data.product_unit_id_fk);
				return data.product_id || data.text;
			},
			minimumInputLength: 2,
			placeholder: "Search Name, Barcode, Batch No.",

		});
	}

	function init_select2_serv(id) {
		$(`select[name^="${id}"]`).select2({
			minimumResultsForSearch: -1,
			ajax: {
				url: "models/crul_product.php",
				dataType: 'json',
				type: 'POST',
				quietMillis: 100,
				data: function(data, page) {
					return {
						type: 'search',
						dataType: '',
						condition: '',
						category: '2',
						q: data.term,
						page_limit: 8,
						page: 10
					};
				},
				processResults: function(data, params) {
					params.page = params.page || 1;
					if (data.length > 0) {
						var results = [];
						$.each(data, function(index, item) {
							// console.log(item)
							results.push({
								id: item.product_id,
								text: item.product_name,
								data_unit_id: item.product_unit_id_fk,
								data: item
							});
						});
						return {
							results: results,
							pagination: {
								more: (params.page * 30) < data.length
							}
						};
					}
				}
			},
			escapeMarkup: function(markup) {
				return markup;
			},
			templateResult: function(res) {
				if (res.loading) {
					return res.text;
				}
				if (res.data.product_id == 0) {
					return `
	                    <div class="media">
	                        <div class="media-left media-middle">
	                            <a href="#" class="btn bg-pink-400 btn-rounded btn-icon btn-xlg">
	                                <span class="">${res.data.product_id}</span>
	                            </a>
	                        </div>
	                        <div class="media-body">
	                            <div class="media-heading">
	                                <a href="#" class="letter-icon-title">${res.data.product_name}</a>
	                            </div>
	                        </div>
	                    </div>
	                `;
				} else {
					return `
	                    <div class="media">
	                        <div class="media-left media-middle">
	                            <a href="#" class="btn bg-pink-400 btn-rounded btn-icon btn-xlg">
	                                <span class="">${res.data.product_id}</span>
	                            </a>
	                        </div>
	                        <div class="media-body">
	                            <p>${res.data.product_name}</p>
	                            <p>${res.data.product_barcode}</p>
	                        </div>
	                    </div>
	                `;
				}
			},
			templateSelection: function(data, container) {
				console.error(data)
				// $(data.element).attr('data-custom-attribute', data.product_unit_id_fk);
				return data.product_id || data.text;
			},
			minimumInputLength: 2,
			placeholder: "Search Name, Barcode, Batch No.",

		});
	}

	function setText(element, prefix) {

		var value = $(element).text();
		$(`#${prefix}`).val(value);
		$(`#${prefix}`).trigger('change');
		$(`#${prefix}_searchResult`).empty();

	}

	function get_patient_account(id) {

		$.ajax({
			url: 'models/crul_patient.php',
			type: 'POST',
			data: {
				type: 'get_account',
				id: id
			},
			dataType: 'json',
			success: function(res) {

				$("#old_debits").val((res.data[0].total_debit));
				$("#total_paid_fix").val((res.data[0].total_credit));
				$("#total_remained_fix").val((res.data[0].total_remained));


			},
			complete: function() {
				//  me.data('requestRunning', false);
			}

		}); // submit ajax

	}


	$(document).ready(function() {

		$.fn.modal.Constructor.prototype.enforceFocus = function() {
			$(document)
				.off('focusin.bs.modal') // guard against infinite focus loop
				.on('focusin.bs.modal', $.proxy(function(e) {
					if (this.$element[0] !== e.target && !this.$element.has(e.target).length && !$(e.target).closest('.select2-dropdown').length) {
						this.$element.trigger('focus')
					}
				}, this))
		}

		// Prevent Close Modal when click outside it

		$.fn.modal.prototype.constructor.Constructor.DEFAULTS.backdrop = 'static';

		// Prevent Close Modal when Press Escape

		// $.fn.modal.prototype.constructor.Constructor.DEFAULTS.keyboard = false;




		$(".datatable-column-search-inputs").on('dblclick', 'tr', function(e) {
			e.preventDefault();
			var value = $(this).closest('tr').children('td:first').text();
			var last = $(this).closest('tr').children('td:last').html();
			let position = last.search("edit_items");
			if (position > -1) {
				edit_items(value)
			}

		})

		$("#delete-img").on('click', function(e) {
			e.preventDefault();

			var id = $("#image_file_id").val();
			var tbl = $("#table_name_img").val();
			var fld = $("#image_field_name").val();
			var pri = $("#primary_key_name").val();
			deleteImage(id, tbl, pri, fld)
		});

		$(".add-patient").on('click', function(e) {
			e.preventDefault();
			$('#cp_form_cont').modal('toggle');
		});

		$("#cp_first_name, #cp_second_name, #cp_third_name").keyup(function() {
			var search = $(this).val();
			var prefix = $(this).attr('id');

			if (search != "") {

				$.ajax({
					url: "models/crul_patient.php",
					type: 'post',
					data: {
						q: search,
						type: 'autocomplete'
					},
					dataType: 'json',
					success: function(response) {

						var len = response.length;
						$(`#${prefix}_searchResult`).empty();
						for (var i = 0; i < len; i++) {
							var name = response[i]['full_name'];
							$(`#${prefix}_searchResult`).append("<li value='" + name + "'>" + name + "</li>");
						}

						// binding click event to li
						$(`#${prefix}_searchResult li`).bind("click", function() {
							setText(this, prefix);
						});


					}
				});
			} else {
				$(`#${prefix}_searchResult`).empty();
			}

		});

		$("#cp_first_name, #cp_second_name, #cp_third_name").change(function() {
			var fn = $("#cp_first_name").val();
			var sn = $("#cp_second_name").val();
			var tn = $("#cp_third_name").val();
			fn = fn.trim();
			sn = sn.trim();
			tn = tn.trim();

			fn = fn.charAt(0).toUpperCase() + fn.slice(1);
			sn = sn.charAt(0).toUpperCase() + sn.slice(1);
			tn = tn.charAt(0).toUpperCase() + tn.slice(1);

			$("#cp_first_name").val(fn);
			$("#cp_second_name").val(sn);
			$("#cp_third_name").val(tn);

			const full_name = fn + " " + sn + " " + tn;

			$("#cp_patient_full_name").val(full_name)
		});

		$("#submit_cp_btn").on('click', function(e) {
			e.preventDefault();
			$("#cp_active-tab").addClass('active');
			$("#cp-bordered-justified-tab1").addClass('active');
			$('#submit_cp_btn_triger').trigger('click');
		});

		$('#cp_form').submit(function(event) {
			event.preventDefault();

			$("#submit_cp_btn").attr('disabled', true);

			var formData = new FormData(this);

			formData.append("type", 'create');

			$.ajax({
					url: "models/crul_patient.php",
					type: "POST",
					dataType: "JSON",
					data: formData,
					processData: false,
					contentType: false
				})
				.done(function(res) {

					$("#submit_cp_btn").attr('disabled', false);


					if (res.is_success == true) {

						$('#cp_form_cont').modal('toggle');
						$("#cp_form")[0].reset();

						var data = {
							id: res.id,
							text: res.patient_full_name
						};

						if ($('#patient_id_fk').find("option[value='" + data.id + "']").length) {
							$('#patient_id_fk').val(data.id).trigger('change');
						} else {
							// Create a DOM Option and pre-select by default
							var newOption = new Option(data.text, data.id, true, true);
							// Append it to the select
							$('#patient_id_fk').append(newOption).trigger('change');
						}

						var company_id_fk = res.company_id_fk;
						var insurance = res.insurance;

						set_GP_Price(insurance, company_id_fk)


						noty({
							width: 200,
							text: i18n.t(res.data),
							type: 'success',
							dismissQueue: true,
							timeout: 2000,
							layout: 'topRight',
							callback: {
								onShow: function() {

								},
								afterShow: function() {
									// show_report(res.id,'Print');
									$(".datatable-column-search-inputs").DataTable().ajax.reload(null, false);

								},
								onClose: function() {

									// location.reload();
								},
								afterClose: function() {},
								onCloseClick: function() {},
							},
						});


					} else {
						swal({
							title: i18n.t("Error"),
							text: i18n.t(res.data),
							confirmButtonColor: "#66BB6A",
							type: "warning"
						});
					}

				})
				.fail(function(err) {
					$("#submit_cp_btn").attr('disabled', false);

					swal({
						title: i18n.t("Error"),
						text: (err),
						confirmButtonColor: "#66BB6A",
						type: "error"
					});
				})
				.always(function() {
					console.log("complete");
					$("#submit_cp_btn").attr('disabled', false);

				});




		});


		if (PAGE_TYPE == 'Report') {
			var $table = $('table.table');
			//change the location of the table in the dom:
			$table.css('background-color', "white");
			$table.floatThead('responsiveContainer')
			$table.floatThead('scrollContainer', true)
			$table.floatThead('autoReflow', true)
			// //cause the floated header to be properly positioned again:
			// // $table.trigger('reflow');
			$table.floatThead({
				top: 45
			});
			$table.floatThead('reflow');
		}

		$(window).scroll(function() {
			if ($(this).scrollTop() > 100) {
				$('#scrolltoTop').fadeIn();
			} else {
				$('#scrolltoTop').fadeOut();
			}

			if ($(this).scrollTop() > 0) {
				$('#scrolltobottom').fadeIn();
			} else {
				$('#scrolltobottom').fadeOut();
			}
		});


		$('#scrolltoTop').click(function() {

			$("html, body").animate({
				scrollTop: 0
			}, 2000);
		});

		$('#scrolltobottom').click(function() {

			$('html,body').animate({
				scrollTop: $(".len").offset().top
			}, 2000)
		});

		$(".datatable-column-search-inputs input")
			.unbind() // Unbind previous default bindings
			.bind("keyup input", function(e) { // Bind our desired behavior
				// If the length is 3 or more characters, or the user pressed ENTER, search
				if (e.keyCode == 13) {
					// Call the API search function
					table.search(this.value).draw();
				}

				table.columns().every(function() {
					var that = this;
					$('input', this.footer()).on('keypress').on('keydown').on('keyup', function(e) {
						if (e.keyCode == 13) {
							if (that.search() !== this.value) {
								that.search(this.value).draw();
							}
						}
					});
				});



				// Ensure we clear the search if they backspace far enough
				if (this.value == "") {
					table.search("").draw();
				}
				return;
			});


	});
</script>