<?php

require_once __DIR__ . '/vendor/autoload.php';

use Mpdf\Mpdf;

$mpdf = new Mpdf([
    'margin_top' => 50,
    'margin_bottom' => 50,
]);

// Header/Footer Setup
$mpdf->SetHTMLHeader('
    <div style="text-align:center; padding:10px; border-bottom:1px solid #ccc;">
        Document Header
    </div>
');

$mpdf->SetHTMLFooter('
    <div style="text-align:center; padding:10px; border-top:1px solid #ccc;">
        Page {PAGENO} of {nbpg}
    </div>
');

// CSS to prevent row breaking
$css = '
    tr { 
        page-break-inside: avoid !important; /* Keep rows intact */
    }
    table {
        border-collapse: collapse;
        width: 100%;
    }
    td {
        padding: 8px;
        border: 1px solid #ddd;
    }
';

// Generate 100-row table
$table = '<table>';
for ($i = 1; $i <= 100; $i++) {
    $table .= "<tr><td>Row $i</td><td>Content " . str_repeat("... ", 20) . "</td></tr>";
}
$table .= '</table>';

$mpdf->WriteHTML("$css $table");
$mpdf->Output('document.pdf', 'I');

?>

